/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.search.Aggregation;
import io.polyglotted.elastic.search.AggsConverter;
import io.polyglotted.elastic.search.AggsFlattener;
import io.polyglotted.elastic.search.QueryMaker;
import io.polyglotted.elastic.search.QueryResponse;
import io.polyglotted.elastic.search.ResponseBuilder;
import io.polyglotted.elastic.search.ResponseHeader;
import io.polyglotted.elastic.search.SearcherException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregations;

abstract class SearchUtil {
    SearchUtil() {
    }

    static <T> QueryResponse.Builder responseBuilder(SearchResponse searchResponse, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        QueryResponse.Builder responseBuilder = QueryResponse.responseBuilder();
        responseBuilder.header(SearchUtil.headerFrom(searchResponse));
        if (SearchUtil.getReturnedHits(searchResponse) > 0) {
            responseBuilder.results(resultBuilder.buildFrom(searchResponse, verbose));
        }
        return responseBuilder;
    }

    static SearchResponse performScroll(ElasticClient client, AuthHeader auth, SearchResponse response) {
        return client.searchScroll(auth, new SearchScrollRequest(response.getScrollId()).scroll(QueryMaker.DEFAULT_KEEP_ALIVE));
    }

    static void performClearScroll(ElasticClient client, AuthHeader auth, String scrollId) {
        if (StrUtil.notNullOrEmpty((String)scrollId)) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            client.clearScroll(auth, clearScrollRequest);
        }
    }

    static ResponseHeader headerFrom(SearchResponse response) {
        return new ResponseHeader(response.getTook().millis(), SearchUtil.getTotalHits(response), SearchUtil.getReturnedHits(response), response.getScrollId());
    }

    static XContentBuilder headerFrom(SearchResponse response, XContentBuilder builder) throws IOException {
        builder.startObject("header").field("tookInMillis", response.getTook().millis()).field("totalHits", SearchUtil.getTotalHits(response)).field("returnedHits", SearchUtil.getReturnedHits(response));
        return response.getScrollId() != null ? builder.field("scrollId", response.getScrollId()).endObject() : builder.endObject();
    }

    static int getReturnedHits(SearchResponse response) {
        return response.getHits().getHits().length;
    }

    static long getTotalHits(SearchResponse response) {
        return response.getHits().getTotalHits();
    }

    static MapResult hitSource(SearchHit hit) {
        return Objects.requireNonNull(hit).hasSource() ? MapResult.simpleResult((Map)hit.getSourceAsMap()) : MapResult.simpleResult();
    }

    static List<Aggregation> buildAggs(SearchResponse response) {
        ListBuilder.ImmutableListBuilder result = ListBuilder.immutableListBuilder();
        Aggregations aggregations = response.getAggregations();
        if (aggregations != null) {
            for (org.elasticsearch.search.aggregations.Aggregation agg : aggregations) {
                result.add((Object)AggsConverter.detectAgg(agg).build());
            }
        }
        return result.build();
    }

    static XContentBuilder buildAggs(SearchResponse response, boolean flattenAgg, XContentBuilder result) throws IOException {
        Aggregations aggregations = response.getAggregations();
        if (aggregations != null) {
            return flattenAgg ? SearchUtil.performFlatten(result, aggregations) : SearchUtil.performInternal(result, aggregations);
        }
        return result;
    }

    private static XContentBuilder performFlatten(XContentBuilder result, Aggregations aggregations) throws IOException {
        result.startObject("flattened");
        for (org.elasticsearch.search.aggregations.Aggregation agg : aggregations) {
            Aggregation aggregation = AggsConverter.detectAgg(agg).build();
            Iterator<List<Object>> flattened = AggsFlattener.flattenAggs(aggregation);
            result.startArray(aggregation.label);
            while (flattened.hasNext()) {
                result.value(flattened.next());
            }
            result.endArray();
        }
        return result.endObject();
    }

    private static XContentBuilder performInternal(XContentBuilder result, Aggregations aggregations) throws IOException {
        aggregations.toXContent(result, ToXContent.EMPTY_PARAMS);
        return result;
    }

    static SearcherException failureException(Exception ex) {
        return new SearcherException(Strings.toString((XContentBuilder)SearchUtil.failureContent(XContentFactory.jsonBuilder().startObject(), ex).endObject()));
    }

    static XContentBuilder failureContent(XContentBuilder builder, Exception ex) throws Exception {
        if (ex == null) {
            return builder.field("error", "unknown");
        }
        ElasticsearchException[] rootCauses = SearchUtil.localGuessRootCauses(ex);
        builder.startObject("error");
        builder.startArray("root_cause");
        for (ElasticsearchException rootCause : rootCauses) {
            builder.startObject().field("type", (String)ReflectionUtil.safeInvoke((Object)rootCause, (String)"getExceptionName", (Object[])new Object[0])).field("reason", rootCause.getMessage()).endObject();
        }
        return builder.endArray().field("type", ElasticsearchException.getExceptionName((Throwable)ex)).field("reason", ex.getMessage()).endObject();
    }

    private static ElasticsearchException[] localGuessRootCauses(Throwable t) {
        Throwable ex = ExceptionsHelper.unwrapCause((Throwable)t);
        if (ex instanceof ElasticsearchException) {
            ElasticsearchException esx = (ElasticsearchException)ex;
            Throwable[] suppressed = esx.getSuppressed();
            return suppressed.length > 0 ? SearchUtil.buildSuppressExes(suppressed[0]) : esx.guessRootCauses();
        }
        return SearchUtil.newElasticsearchExes(t);
    }

    private static ElasticsearchException[] buildSuppressExes(Throwable suppressed) {
        ElasticsearchException[] elasticsearchExceptionArray;
        if (suppressed instanceof ElasticsearchException) {
            ElasticsearchException[] elasticsearchExceptionArray2 = new ElasticsearchException[1];
            elasticsearchExceptionArray = elasticsearchExceptionArray2;
            elasticsearchExceptionArray2[0] = (ElasticsearchException)suppressed;
        } else {
            elasticsearchExceptionArray = suppressed instanceof ResponseException ? SearchUtil.unwrapRespEx((ResponseException)suppressed) : SearchUtil.newElasticsearchExes(suppressed);
        }
        return elasticsearchExceptionArray;
    }

    private static ElasticsearchException[] unwrapRespEx(ResponseException rex) {
        String message = EntityUtils.toString((HttpEntity)rex.getResponse().getEntity());
        List rootCauses = BaseSerializer.deserialize((String)message).deepCollect("error.root_cause", MapRetriever.MAP_CLASS);
        if (!rootCauses.isEmpty()) {
            ElasticsearchException[] result = new ElasticsearchException[rootCauses.size()];
            int index = 0;
            for (Map rootCause : rootCauses) {
                result[index++] = SearchUtil.newElasticsearchEx(MapRetriever.reqdStr((Map)rootCause, (String)"type"), MapRetriever.reqdStr((Map)rootCause, (String)"reason"), null);
            }
            return result;
        }
        return new ElasticsearchException[]{new ElasticsearchException(message, (Throwable)rex, new Object[0])};
    }

    private static ElasticsearchException[] newElasticsearchExes(Throwable t) {
        return new ElasticsearchException[]{SearchUtil.newElasticsearchEx(ElasticsearchException.getExceptionName((Throwable)t), t.getMessage(), t)};
    }

    private static ElasticsearchException newElasticsearchEx(final String name, String message, Throwable t) {
        return new ElasticsearchException(message, t, new Object[0]){

            protected String getExceptionName() {
                return name;
            }
        };
    }
}

