/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.elastic.search.Aggregation;
import io.polyglotted.elastic.search.ResponseHeader;
import java.util.List;
import java.util.Objects;

public final class QueryResponse {
    public final ResponseHeader header;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<Object> results;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<Aggregation> aggregations;

    public List<MapResult> results() {
        return this.resultsAs(MapResult.class);
    }

    public <T> List<T> resultsAs(Class<? extends T> tClass) {
        return CollUtil.transformList(this.results, tClass::cast);
    }

    public boolean hasNextScroll() {
        return this.header.returnedHits > 0L;
    }

    public String scrollId() {
        return this.header.scrollId;
    }

    public static Builder responseBuilder() {
        return new Builder();
    }

    public QueryResponse(ResponseHeader header, List<Object> results, List<Aggregation> aggregations) {
        this.header = header;
        this.results = results;
        this.aggregations = aggregations;
    }

    public static class Builder {
        private ResponseHeader header = null;
        private final ListBuilder.ImmutableListBuilder<Object> results = ListBuilder.immutableListBuilder();
        private final ListBuilder.ImmutableListBuilder<Aggregation> aggregations = ListBuilder.immutableListBuilder();

        public void results(Iterable<?> objects) {
            this.results.addAll(objects);
        }

        public Builder result(Object object) {
            this.results.add(object);
            return this;
        }

        public void aggregation(Aggregation.Builder builder) {
            this.aggregations.add((Object)builder.build());
        }

        public QueryResponse build() {
            return new QueryResponse(Objects.requireNonNull(this.header, "header is required"), (List<Object>)this.results.build(), (List<Aggregation>)this.aggregations.build());
        }

        public Builder header(ResponseHeader header) {
            this.header = header;
            return this;
        }

        private Builder() {
        }
    }
}

