/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.elastic.search.Expression;
import java.util.ArrayList;
import java.util.List;

public abstract class Expressions {
    public static BoolBuilder bool() {
        return new BoolBuilder();
    }

    public static Expression exists(String field) {
        return Expression.withLabel("Exists", field);
    }

    public static Expression missing(String field) {
        return Expression.withLabel("Missing", field);
    }

    public static Expression all() {
        return Expression.withLabel("All", "");
    }

    public static Expression allIndex() {
        return Expressions.bool().allIndex().build();
    }

    public static Expression archiveIndex() {
        return Expressions.bool().archiveIndex().build();
    }

    public static Expression pendingApproval() {
        return Expressions.bool().pendingApproval().build();
    }

    public static Expression approvalRejected() {
        return Expressions.bool().rejected().build();
    }

    public static Expression liveIndex() {
        return Expressions.bool().liveIndex().build();
    }

    public static Expression equalsTo(String field, Object value) {
        return value == null ? Expressions.missing(field) : Expression.withValue("Eq", field, value);
    }

    public static Expression notEquals(String field, Object value) {
        return value == null ? Expressions.exists(field) : Expression.withValue("Ne", field, value);
    }

    public static Expression text(String field, Object value) {
        return Expression.withMap("Text", (String)NullUtil.nonNull((Object)field, (Object)""), (MapResult.ImmutableResult)MapResult.immutableResult((String)"_val", (Object)value));
    }

    public static <E extends Comparable<E>> Expression in(String field, Iterable<E> values) {
        return Expression.withArray("In", field, ListBuilder.immutableList(values));
    }

    public static class BoolBuilder {
        private final List<Expression> musts = new ArrayList<Expression>();
        private final List<Expression> filters = new ArrayList<Expression>();
        private final List<Expression> shoulds = new ArrayList<Expression>();
        private final List<Expression> mustNots = new ArrayList<Expression>();

        public BoolBuilder allIndex() {
            return this.filter(Expressions.exists("&timestamp"));
        }

        public BoolBuilder discarded() {
            return this.filter(Expressions.equalsTo("&status", "DISCARDED"));
        }

        public BoolBuilder rejected() {
            return this.filter(Expressions.equalsTo("&status", "REJECTED")).not(Expressions.exists("&expiry"));
        }

        public BoolBuilder pendingOrRejected() {
            return this.filter(Expressions.in("&status", ListBuilder.immutableList((Object[])new String[]{"PENDING", "PENDING_DELETE", "REJECTED"}))).not(Expressions.exists("&expiry"));
        }

        public BoolBuilder pendingApproval() {
            return this.filter(Expressions.in("&status", ListBuilder.immutableList((Object[])new String[]{"PENDING", "PENDING_DELETE"}))).not(Expressions.exists("&expiry"));
        }

        public BoolBuilder archiveIndex() {
            return this.filters(Expressions.exists("&status"), Expressions.exists("&expiry"));
        }

        public BoolBuilder liveIndex() {
            return this.filter(Expressions.exists("&timestamp")).nots(Expressions.exists("&status"), Expressions.exists("&expiry"));
        }

        public BoolBuilder liveOrPending() {
            return this.must(Expressions.exists("&timestamp")).not(Expressions.exists("&expiry")).should(Expressions.bool().not(Expressions.exists("&status"))).should(Expressions.in("&status", ListBuilder.immutableList((Object[])new String[]{"PENDING", "PENDING_DELETE", "REJECTED"})));
        }

        public BoolBuilder must(Expression expr) {
            if (expr != null) {
                this.musts.add(expr);
            }
            return this;
        }

        public BoolBuilder musts(Expression ... exprs) {
            for (Expression expr : exprs) {
                this.must(expr);
            }
            return this;
        }

        public BoolBuilder filter(Expression expr) {
            if (expr != null) {
                this.filters.add(expr);
            }
            return this;
        }

        public BoolBuilder filters(Expression ... exprs) {
            for (Expression expr : exprs) {
                this.filter(expr);
            }
            return this;
        }

        public BoolBuilder should(BoolBuilder builder) {
            return this.should(builder.build());
        }

        public BoolBuilder should(Expression expr) {
            if (expr != null) {
                this.shoulds.add(expr);
            }
            return this;
        }

        public BoolBuilder shoulds(Expression ... exprs) {
            for (Expression expr : exprs) {
                this.should(expr);
            }
            return this;
        }

        public BoolBuilder not(Expression expr) {
            if (expr != null) {
                this.mustNots.add(expr);
            }
            return this;
        }

        public BoolBuilder nots(Expression ... exprs) {
            for (Expression expr : exprs) {
                this.not(expr);
            }
            return this;
        }

        public Expression build() {
            return Expression.withMap("Bool", "Bool", (MapResult.ImmutableResult)MapResult.immutableResult((String)"must", this.musts, (String)"filter", this.filters, (String)"should", this.shoulds, (String)"must_not", this.mustNots));
        }

        private BoolBuilder() {
        }
    }
}

