/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ConversionUtil;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.elastic.search.Aggregation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Bucket {
    public final String key;
    public final Object value;
    public final long count;
    public final List<Aggregation> aggregations;

    public boolean hasAggregations() {
        return this.aggregations.size() > 0;
    }

    public static Builder deserializeBucket(MapResult map) {
        Builder builder = Bucket.bucketBuilder().key(MapRetriever.reqdStr((Map)map, (String)"key")).value(MapRetriever.reqdValue((Map)map, (String)"value")).count(ConversionUtil.asLong((Object)MapRetriever.optValue((Map)map, (String)"count", (Object)0L)));
        for (MapResult agg : MapRetriever.listVal((Map)map, (String)"aggregations")) {
            builder.aggregation(Aggregation.deserializeAgg(agg));
        }
        return builder;
    }

    public static Builder bucketBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Bucket(" + this.key + ", " + this.count + ", " + this.aggregations + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)o;
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$value = this.value;
        Object other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        List<Aggregation> this$aggregations = this.aggregations;
        List<Aggregation> other$aggregations = other.aggregations;
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        long $count = this.count;
        result = result * 59 + (int)($count >>> 32 ^ $count);
        List<Aggregation> $aggregations = this.aggregations;
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    public Bucket(String key, Object value, long count, List<Aggregation> aggregations) {
        this.key = key;
        this.value = value;
        this.count = count;
        this.aggregations = aggregations;
    }

    public static class Builder {
        private String key;
        private Object value;
        private long count;
        private final List<Aggregation.Builder> builders = new ArrayList<Aggregation.Builder>();

        public void aggregation(Aggregation.Builder builder) {
            this.builders.add(builder);
        }

        public Bucket build() {
            return new Bucket(this.key, this.value, this.count, CollUtil.transformList(this.builders, Aggregation.Builder::build));
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }
    }
}

