/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.elastic.search.Aggregation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

abstract class AggsFlattener {
    AggsFlattener() {
    }

    static Iterator<List<Object>> flattenAggs(Aggregation aggs) {
        return AggsFlattener.flattenAggs(new String[0], aggs).iterator();
    }

    private static Stream<List<Object>> flattenAggs(String[] strings, Aggregation aggs) {
        if (!aggs.hasBuckets()) {
            return Stream.of(AggsFlattener.build(strings, aggs.valueIterable()));
        }
        if (aggs.buckets().isEmpty()) {
            String[] inner = AggsFlattener.makeArray(strings, aggs.label);
            return Stream.of(AggsFlattener.build(inner, 0L));
        }
        return aggs.buckets().stream().flatMap(bucket -> {
            String[] inner = AggsFlattener.makeArray(strings, bucket.key);
            return !bucket.hasAggregations() ? Stream.of(AggsFlattener.build(inner, bucket.count)) : bucket.aggregations.stream().flatMap(child -> AggsFlattener.flattenAggs(inner, child));
        });
    }

    private static String[] makeArray(String[] strings, String key) {
        String[] result = new String[strings.length + 1];
        System.arraycopy(strings, 0, result, 0, strings.length);
        result[strings.length] = key;
        return result;
    }

    private static List<Object> build(String[] strings, long docCount) {
        return ListBuilder.immutableListBuilder().addAll(Arrays.asList((Object[])strings)).add((Object)docCount).build();
    }

    private static List<Object> build(String[] strings, Iterable<Map.Entry<String, Object>> aggs) {
        return ListBuilder.immutableListBuilder().addAll(Arrays.asList((Object[])strings)).addAll((Iterable)CollUtil.transform(aggs, Map.Entry::getValue)).build();
    }
}

