/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.Jsoner;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.common.MetaFields;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public final class NoopException
extends RuntimeException
implements Jsoner {
    private final String id;

    public NoopException(MapResult current) {
        super(NoopException.buildMessage(current));
        this.id = MetaFields.reqdId(current);
    }

    public String toJson() {
        return "{\"" + this.id + "\":" + this.getMessage() + "}";
    }

    private static String buildMessage(MapResult current) {
        return Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("&id", MetaFields.reqdId(current)).field("&key", MetaFields.reqdKey(current)).field("&model", MetaFields.model(current)).field("&result", "noop").field("&timestamp", MetaFields.timestamp(current)).endObject());
    }

    public static String jsonMsg(Exception ex) {
        return ex instanceof NoopException ? ex.getMessage() : BaseSerializer.serialize((Object)MapBuilder.immutableMap((Object)"error", (Object)ex.getMessage()));
    }

    public static String jsonResult(Exception ex) {
        return ex instanceof NoopException ? ((NoopException)ex).toJson() : BaseSerializer.serialize((Object)MapBuilder.immutableMap((Object)"error", (Object)ex.getMessage()));
    }
}

