/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.common.DocStatus;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.common.Notification;
import io.polyglotted.elastic.index.ApprovalUtil;
import io.polyglotted.elastic.index.IgnoreErrors;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public final class BulkRecord {
    public final String repo;
    public final String model;
    public final String parent;
    public final List<IndexRecord> records;
    public final IgnoreErrors ignoreErrors;
    public final Validator validator;
    private final Map<String, String> actions = MapBuilder.simpleMap();
    private volatile boolean hasNoFailure = true;
    private volatile Map<Integer, String> indexMap = MapBuilder.immutableMap();

    public Notification notification() {
        return this.notification(null);
    }

    public Notification notification(String realm) {
        Notification.Builder builder = Notification.notificationBuilder().realm(realm);
        this.records.forEach(rec -> builder.keyAction(rec.id, rec.simpleKey(), this.actions.get(rec.id)));
        return builder.build();
    }

    public String toResult() {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        for (IndexRecord rec : this.records) {
            rec.toAction(builder, this.actions.get(rec.id));
        }
        return Strings.toString((XContentBuilder)builder.endObject());
    }

    public int size() {
        return this.records.size();
    }

    void actionWith(int index, String result) {
        this.actionWith(this.indexMap.get(index), result);
    }

    void failureWith(String id, String result) {
        this.actionWith(id, result);
        this.hasNoFailure = false;
    }

    void actionWith(String id, String result) {
        this.actions.put(id, result);
    }

    public static Builder bulkBuilder(String repo, String model, long timestamp, String user) {
        return new Builder(Objects.requireNonNull(repo), Objects.requireNonNull(model), timestamp, Objects.requireNonNull(user));
    }

    private static boolean isChangeAction(String action) {
        return "created".equals(action) || "updated".equals(action) || "deleted".equals(action);
    }

    private BulkRecord(String repo, String model, String parent, List<IndexRecord> records, IgnoreErrors ignoreErrors, Validator validator) {
        this.repo = repo;
        this.model = model;
        this.parent = parent;
        this.records = records;
        this.ignoreErrors = ignoreErrors;
        this.validator = validator;
    }

    public boolean hasNoFailure() {
        return this.hasNoFailure;
    }

    public Map<Integer, String> indexMap() {
        return this.indexMap;
    }

    public BulkRecord indexMap(Map<Integer, String> indexMap) {
        this.indexMap = indexMap;
        return this;
    }

    public static class Builder {
        @NonNull
        private final String repo;
        @NonNull
        private final String model;
        private final long timestamp;
        @NonNull
        private final String user;
        private String parent;
        private boolean hasApproval;
        @NonNull
        private IgnoreErrors ignoreErrors = IgnoreErrors.STRICT;
        @NonNull
        private Validator validator = Validator.STRICT;
        private final ListBuilder.ImmutableListBuilder<IndexRecord.Builder> records = ListBuilder.immutableListBuilder();

        public Builder hasApproval() {
            return this.hasApproval(true);
        }

        public Builder record(IndexRecord.Builder record) {
            this.records.add((Object)this.checkParent(record).userTs(this.user, this.timestamp));
            return this;
        }

        public Builder records(Iterable<IndexRecord.Builder> records) {
            for (IndexRecord.Builder rec : records) {
                this.record(rec);
            }
            return this;
        }

        public Builder objects(Iterable<MapResult> docs) {
            for (MapResult doc : docs) {
                this.record(this.indexRec(doc));
            }
            return this;
        }

        public Builder objectsWith(Iterable<MapResult> docs, String pipeline) {
            for (MapResult doc : docs) {
                this.record(this.indexRec(doc).pipeline(pipeline));
            }
            return this;
        }

        private IndexRecord.Builder indexRec(MapResult doc) {
            IndexRecord.Builder builder = this.hasApproval ? IndexRecord.createRecord(this.repo, ApprovalUtil.approvalModel(this.model), MetaFields.id(doc), MetaFields.parent(doc), doc).status(DocStatus.PENDING) : IndexRecord.saveRecord(this.repo, this.model, MetaFields.id(doc), MetaFields.parent(doc), MetaFields.tstamp(doc), doc);
            return builder.userTs(this.user, this.timestamp);
        }

        private IndexRecord.Builder checkParent(IndexRecord.Builder record) {
            Assertions.checkBool((boolean)Objects.equals(this.parent, record.parent), (String)"bulk record cannot index child records for multiple parents");
            return record;
        }

        public BulkRecord build() {
            return new BulkRecord(this.repo, this.model, this.parent, CollUtil.transformList((List)this.records.build(), IndexRecord.Builder::build), this.ignoreErrors, this.validator);
        }

        public Builder(@NonNull String repo, @NonNull String model, long timestamp, @NonNull String user) {
            if (repo == null) {
                throw new NullPointerException("repo is marked @NonNull but is null");
            }
            if (model == null) {
                throw new NullPointerException("model is marked @NonNull but is null");
            }
            if (user == null) {
                throw new NullPointerException("user is marked @NonNull but is null");
            }
            this.repo = repo;
            this.model = model;
            this.timestamp = timestamp;
            this.user = user;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder hasApproval(boolean hasApproval) {
            this.hasApproval = hasApproval;
            return this;
        }

        public Builder ignoreErrors(@NonNull IgnoreErrors ignoreErrors) {
            if (ignoreErrors == null) {
                throw new NullPointerException("ignoreErrors is marked @NonNull but is null");
            }
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public Builder validator(@NonNull Validator validator) {
            if (validator == null) {
                throw new NullPointerException("validator is marked @NonNull but is null");
            }
            this.validator = validator;
            return this;
        }
    }
}

