/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.elastic.common.DocResult;
import io.polyglotted.elastic.common.DocStatus;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.RecordAction;
import io.polyglotted.elastic.index.ValidateException;
import io.polyglotted.elastic.search.Expressions;
import io.polyglotted.elastic.search.Finder;
import io.polyglotted.elastic.search.QueryMaker;
import io.polyglotted.elastic.search.ResponseBuilder;
import io.polyglotted.elastic.search.Searcher;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public abstract class ApprovalUtil {
    public static String approvalModel(String model) {
        return model + "$approval";
    }

    public static Expressions.BoolBuilder pendingBuilder(String m, String id) {
        return Finder.idBuilder(ApprovalUtil.approvalModel(m), Expressions.equalsTo("&id", id)).pendingApproval();
    }

    public static DocResult fetchApprovalDoc(Searcher searcher, AuthHeader esAuth, String repo, String model, String id) {
        return ValidateException.validateNotNull(ApprovalUtil.fetchPendingDoc(searcher, esAuth, repo, model, id, Expressions.bool().pendingApproval()), "cannot find approval document " + id + " for model " + model);
    }

    public static DocResult fetchPendingDoc(Searcher searcher, AuthHeader esAuth, String repo, String model, String id, Expressions.BoolBuilder boolBuilder) {
        SearchRequest searchRequest = QueryMaker.filterToRequest(repo, boolBuilder.musts(Expressions.equalsTo("&model", ApprovalUtil.approvalModel(model)), Expressions.equalsTo("&id", id)).build(), FetchSourceContext.FETCH_SOURCE, ListBuilder.immutableList(), 1);
        List<DocResult> response = searcher.searchBy(esAuth, searchRequest, ResponseBuilder.DocResultBuilder, Verbose.NONE).resultsAs(DocResult.class);
        return response.size() > 0 ? response.get(0) : null;
    }

    public static Pair<IndexRecord, IndexRecord> approvePair(String repo, DocResult approvalDoc, String comment, long millis, String user) {
        DocStatus newStatus = ApprovalUtil.checkStatus(approvalDoc);
        IndexRecord approvalRec = approvalDoc.recordOf(newStatus == DocStatus.PENDING ? RecordAction.APPROVE : RecordAction.DELETE, repo).userTs(user, millis).comment(comment, false).build();
        RecordAction newAction = newStatus == DocStatus.PENDING_DELETE ? RecordAction.DELETE : RecordAction.CREATE;
        return Pair.pair((Object)approvalRec, (Object)approvalDoc.recordOf(newAction, repo, approvalDoc.nakedModel(), true).userTs(user, millis).build());
    }

    public static IndexRecord reject(String repo, DocResult approvalDoc, RecordAction action, String comment, long millis, String user) {
        ApprovalUtil.checkStatus(approvalDoc);
        return approvalDoc.recordOf(action, repo).status(DocStatus.REJECTED).userTs(user, millis).comment(comment, true).build();
    }

    public static IndexRecord discard(String repo, DocResult approvalDoc, RecordAction action, String comment, long millis, String user) {
        ApprovalUtil.checkStatus(approvalDoc);
        return approvalDoc.recordOf(action, repo).status(DocStatus.DISCARDED).userTs(user, millis).comment(comment, true).build();
    }

    private static DocStatus checkStatus(DocResult existing) {
        DocStatus status = existing.status();
        if (status != DocStatus.PENDING && status != DocStatus.PENDING_DELETE) {
            throw new ValidateException(403, "status invalid for approval " + (Object)((Object)status));
        }
        return status;
    }
}

