/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.UrnUtil;
import io.polyglotted.elastic.common.DocStatus;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class MetaFields {
    public static final String ALL_FIELD = "&all";
    public static final String ANCESTOR_FIELD = "&ancestor";
    public static final String APPROVAL_ROLES_FIELD = "&approvalRoles";
    public static final String AUTO_COMPLETE_FIELD = "&autoComplete";
    public static final String COMMENT_FIELD = "&comment";
    public static final String EXPIRY_FIELD = "&expiry";
    public static final String HIGHLTGHT_FIELD = "&highlight";
    public static final String ID_FIELD = "&id";
    public static final String KEY_FIELD = "&key";
    public static final String LINK_FIELD = "&link";
    public static final String MODEL_FIELD = "&model";
    public static final String PARENT_FIELD = "&parent";
    public static final String REALM_FIELD = "&realm";
    public static final String RESULT_FIELD = "&result";
    public static final String SEQUENCE_FIELD = "&sequence";
    public static final String STATUS_FIELD = "&status";
    public static final String TIMESTAMP_FIELD = "&timestamp";
    public static final String TRAITFQN_FIELD = "&traitFqn";
    public static final String UNIQUE_FIELD = "&uniqueProps";
    public static final String UPDATER_FIELD = "&updater";
    public static final String USER_FIELD = "&user";
    public static final String VERSION_FIELD = "&version";
    private static final List<String> KEY_FIELDS = ListBuilder.immutableList((Object[])new String[]{"&model", "&id", "&timestamp", "&key", "&status", "&expiry"});
    public static final List<String> ALL_FIELDS = ListBuilder.immutableList((Object[])new String[]{"&ancestor", "&approvalRoles", "&comment", "&expiry", "&id", "&key", "&link", "&model", "&parent", "&realm", "&sequence", "&status", "&traitFqn", "&timestamp", "&updater", "&user"});

    public static void addMeta(Object item, String field, Object value) {
        MetaFields.addMetaField(MetaFields.mapValue(item), field, value);
    }

    public static void addMetaField(MapResult mapValue, String field, Object value) {
        mapValue.put((Object)field, value);
    }

    public static void removeMeta(Object item, String field) {
        MetaFields.mapValue(item).remove((Object)field);
    }

    public static <T> T reqdMeta(Object object, String field) {
        return (T)MapRetriever.reqdValue((Map)MetaFields.mapValue(object), (String)field);
    }

    public static boolean isMeta(String field) {
        return field.indexOf(38) == 0;
    }

    public static boolean isNotMeta(String field) {
        return field.indexOf(38) != 0;
    }

    public static String model(Object object) {
        return (String)MetaFields.reqdMeta(object, MODEL_FIELD);
    }

    public static String reqdId(Object object) {
        return (String)MetaFields.reqdMeta(object, ID_FIELD);
    }

    public static String reqdKey(Object object) {
        return (String)MetaFields.reqdMeta(object, KEY_FIELD);
    }

    public static String id(Object object) {
        return (String)MapRetriever.optValue((Map)MetaFields.mapValue(object), (String)ID_FIELD);
    }

    public static String parent(Object object) {
        return (String)MapRetriever.optValue((Map)MetaFields.mapValue(object), (String)PARENT_FIELD);
    }

    public static long timestamp(Object object) {
        return MapRetriever.longStrVal((Map)MetaFields.mapValue(object), (String)TIMESTAMP_FIELD, (long)-3L);
    }

    public static Long tstamp(Object object) {
        return MapRetriever.longStrVal((Map)MetaFields.mapValue(object), (String)TIMESTAMP_FIELD);
    }

    public static String keyString(MapResult map) {
        return UrnUtil.urnOf((String)MetaFields.model(map), (String)MetaFields.id(map));
    }

    public static DocStatus status(MapResult map) {
        return DocStatus.fromStatus(map.get((Object)STATUS_FIELD).toString());
    }

    public static MapBuilder.ImmutableMapBuilder<String, Object> readKey(MapResult map) {
        MapBuilder.ImmutableMapBuilder builder = MapBuilder.immutableMapBuilder();
        MetaFields.putVal(map, (String)Assertions.checkContains((Map)map, (Object)ID_FIELD), (MapBuilder)builder);
        MetaFields.putVal(map, (String)Assertions.checkContains((Map)map, (Object)KEY_FIELD), (MapBuilder)builder);
        MetaFields.putVal(map, LINK_FIELD, (MapBuilder)builder);
        MetaFields.putVal(map, (String)Assertions.checkContains((Map)map, (Object)MODEL_FIELD), (MapBuilder)builder);
        MetaFields.putVal(map, PARENT_FIELD, (MapBuilder)builder);
        MetaFields.putTs(map, (String)Assertions.checkContains((Map)map, (Object)TIMESTAMP_FIELD), (MapBuilder)builder);
        return builder;
    }

    public static MapResult readHeader(MapResult map) {
        return MetaFields.readHeader(map, true);
    }

    public static MapResult readHeader(MapResult map, boolean mandatory) {
        MapBuilder.SimpleMapBuilder builder = MapBuilder.simpleMapBuilder(TreeMap::new);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)MODEL_FIELD) : MODEL_FIELD, (MapBuilder)builder);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)ID_FIELD) : ID_FIELD, (MapBuilder)builder);
        MetaFields.putTs(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)TIMESTAMP_FIELD) : TIMESTAMP_FIELD, (MapBuilder)builder);
        MetaFields.putVal(map, mandatory ? (String)Assertions.checkContains((Map)map, (Object)KEY_FIELD) : KEY_FIELD, (MapBuilder)builder);
        if (map.containsKey((Object)STATUS_FIELD)) {
            builder.put((Object)STATUS_FIELD, (Object)MetaFields.status(map));
        }
        MetaFields.putTs(map, EXPIRY_FIELD, (MapBuilder)builder);
        CollUtil.filterKeys((Map)map, MetaFields::isMeta).forEach((key, value) -> {
            if (!KEY_FIELDS.contains(key)) {
                builder.put(key, value);
            }
        });
        return builder.immutable();
    }

    private static void putTs(MapResult map, String property, MapBuilder builder) {
        if (map.containsKey((Object)property)) {
            builder.put((Object)property, (Object)MapRetriever.longStrVal((Map)map, (String)property, (long)-3L));
        }
    }

    private static void putVal(MapResult map, String property, MapBuilder builder) {
        if (map.containsKey((Object)property)) {
            builder.put((Object)property, map.get((Object)property));
        }
    }

    private static MapResult mapValue(Object item) {
        return item instanceof MapResult ? (MapResult)item : (MapResult)NullUtil.nonNull((Object)ReflectionUtil.safeFieldValue((Object)item, (String)"_meta"), (Object)MapResult.simpleResult());
    }
}

