/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.elastic.common.DocStatus;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.RecordAction;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.elasticsearch.action.index.IndexRequest;

public final class DocResult {
    @NonNull
    public final String id;
    public final long version;
    @NonNull
    public final MapResult source;

    public String keyString() {
        return MetaFields.keyString(this.source);
    }

    public String nakedModel() {
        return StrUtil.safePrefix((String)MetaFields.model(this.source), (String)"$");
    }

    public DocStatus status() {
        return MetaFields.status(this.source);
    }

    public IndexRequest ancestorRequest(String repo, MapResult ancillary, String parent, DocStatus status) {
        this.source.putAll((Map)ancillary);
        this.source.put((Object)"&status", (Object)status.name());
        return new IndexRequest(repo, "_doc").routing(parent).source((Map)this.source);
    }

    public IndexRecord.Builder recordOf(RecordAction action, String repo) {
        return this.recordOf(action, repo, MetaFields.model(this.source), false);
    }

    public IndexRecord.Builder recordOf(RecordAction action, String repo, String model, boolean filter) {
        return IndexRecord.expired(action, repo, Objects.requireNonNull(model), MetaFields.reqdId(this.source), MetaFields.parent(this.source), MetaFields.timestamp(this.source), filter ? MapResult.simpleResult(DocResult.filtered(this.source)) : this.source);
    }

    public static Map<String, Object> filtered(MapResult source) {
        return CollUtil.filterKeys((Map)source, MetaFields::isNotMeta);
    }

    public DocResult(@NonNull String id, long version, @NonNull MapResult source) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked @NonNull but is null");
        }
        this.id = id;
        this.version = version;
        this.source = source;
    }
}

