/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.util.StrUtil;

public class ElasticSettings {
    String scheme = "https";
    String host = "localhost";
    int port = 9200;
    int connectTimeoutMillis = 5000;
    int retryTimeoutMillis = 300000;
    int socketTimeoutMillis = 300000;
    boolean insecure = false;
    BootstrapAuth bootstrap = new BootstrapAuth();

    public ElasticSettings setBootstrap(String user, String password) {
        return this.setBootstrap(new BootstrapAuth(user, password));
    }

    boolean sslEnabled() {
        return "https".equals(this.scheme);
    }

    AuthHeader bootstrapAuth() {
        return this.bootstrap.bootstrapAuth();
    }

    public static ElasticSettings elasticSettings() {
        return new ElasticSettings();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getRetryTimeoutMillis() {
        return this.retryTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public BootstrapAuth getBootstrap() {
        return this.bootstrap;
    }

    public ElasticSettings setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public ElasticSettings setHost(String host) {
        this.host = host;
        return this;
    }

    public ElasticSettings setPort(int port) {
        this.port = port;
        return this;
    }

    public ElasticSettings setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public ElasticSettings setRetryTimeoutMillis(int retryTimeoutMillis) {
        this.retryTimeoutMillis = retryTimeoutMillis;
        return this;
    }

    public ElasticSettings setSocketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this;
    }

    public ElasticSettings setInsecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public ElasticSettings setBootstrap(BootstrapAuth bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public static class BootstrapAuth {
        String username = "elastic";
        String password = null;

        AuthHeader bootstrapAuth() {
            return StrUtil.notNullOrEmpty((String)this.username) && StrUtil.notNullOrEmpty((String)this.password) ? AuthHeader.basicAuth((String)this.username, (String)this.password) : null;
        }

        public BootstrapAuth() {
        }

        public BootstrapAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public BootstrapAuth setUsername(String username) {
            this.username = username;
            return this;
        }

        public BootstrapAuth setPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

