/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.TokenUtil;
import io.polyglotted.elastic.admin.IndexSetting;
import io.polyglotted.elastic.admin.Type;
import io.polyglotted.elastic.search.ExprConverter;
import io.polyglotted.elastic.search.Expressions;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public abstract class IndexRequestor {
    private static final Map<String, QueryBuilder> FILTER_BUILDERS = MapBuilder.immutableMapBuilder().put((Object)"ALL", (Object)ExprConverter.buildFilter(Expressions.allIndex())).put((Object)"LIVE", (Object)ExprConverter.buildFilter(Expressions.liveIndex())).put((Object)"ARCHIVE", (Object)ExprConverter.buildFilter(Expressions.archiveIndex())).put((Object)"PENDING", (Object)ExprConverter.buildFilter(Expressions.pendingApproval())).put((Object)"REJECTED", (Object)ExprConverter.buildFilter(Expressions.approvalRejected())).build();

    public static String indexName(IndexSetting setting) {
        return (String)NullUtil.nonNull((Object)MapRetriever.optStr((Map)setting.mapResult, (String)"index_name"), TokenUtil::uniqueToken);
    }

    public static Alias aliasFrom(String name, String filter) {
        return new Alias(name).filter(FILTER_BUILDERS.get(filter));
    }

    public static String indexFile(IndexSetting setting, Type type, String alias) {
        return IndexRequestor.indexFile(setting, type, alias, (List<Alias>)ListBuilder.immutableList());
    }

    public static String indexFile(IndexSetting setting, Type mapping, String writeAlias, List<Alias> readAliases) {
        CreateIndexRequest request = Requests.createIndexRequest((String)IndexRequestor.indexName(setting)).settings(setting.toJson(), XContentType.JSON).mapping("_doc", mapping.toJson(), XContentType.JSON);
        if (writeAlias != null) {
            request.alias(new Alias(writeAlias));
        }
        for (Alias alias : readAliases) {
            request.alias(alias);
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        request.toXContent(builder, ToXContent.EMPTY_PARAMS);
        builder.close();
        return Strings.toString((XContentBuilder)builder);
    }

    public static String templateFile(IndexSetting setting, Type type, String alias) {
        return IndexRequestor.templateFile(setting, type, alias, (List<Alias>)ListBuilder.immutableList());
    }

    public static String templateFile(IndexSetting setting, Type mapping, String writeAlias, List<Alias> readAliases) {
        MapResult result = BaseSerializer.deserialize((String)IndexRequestor.indexFile(setting, mapping, null, readAliases));
        result.put((Object)"index_patterns", (Object)ListBuilder.immutableList((Object[])new String[]{writeAlias}));
        return BaseSerializer.serialize((Object)result);
    }
}

