/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.SortedMapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.elastic.admin.FieldType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class Field
implements Comparable<Field> {
    public final String field;
    public final FieldType type;
    public final String analyzer;
    public final Boolean docValues;
    public final Boolean indexed;
    public final Boolean stored;
    public final Boolean hasFields;
    public final MapResult.ImmutableResult argsMap;
    public final List<String> copyToFields;
    public final Map<String, Field> properties;
    public final boolean excludeFromSrc;

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && BaseSerializer.serialize((Object)this).equals(BaseSerializer.serialize((Object)o));
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public int compareTo(Field other) {
        return other == null ? -1 : this.field.compareTo(other.field);
    }

    public boolean hasProperties() {
        return (this.type == FieldType.NESTED || this.type == FieldType.OBJECT) && this.properties.size() > 0;
    }

    public boolean hasFields() {
        return Boolean.TRUE.equals(this.hasFields) && this.properties.size() > 0;
    }

    public static FieldBuilder keywordField(String field) {
        return Field.fieldBuilder(field, FieldType.KEYWORD);
    }

    public static FieldBuilder nestedField(String field) {
        return Field.fieldBuilder(field, FieldType.NESTED);
    }

    public static FieldBuilder objectField(String field) {
        return Field.fieldBuilder(field, FieldType.OBJECT);
    }

    public static FieldBuilder nonIndexField(String field, FieldType fieldType) {
        return Field.fieldBuilder(field, fieldType).indexed(false);
    }

    public static FieldBuilder textField(String field, String analyzer) {
        return Field.fieldBuilder(field, FieldType.TEXT).analyzer((String)NullUtil.nonNull((Object)analyzer, (Object)"standard"));
    }

    public static FieldBuilder simpleField(String field, FieldType fieldType) {
        return Field.fieldBuilder(field, fieldType.simpleField());
    }

    public static FieldBuilder fieldBuilder(String field, FieldType fieldType) {
        return new FieldBuilder(field, fieldType);
    }

    public String toString() {
        return "Field(" + this.field + ", " + (Object)((Object)this.type) + ", " + this.analyzer + ", " + this.docValues + ", " + this.indexed + ", " + this.stored + ", " + this.hasFields + ", " + this.argsMap + ", " + this.copyToFields + ", " + this.properties + ", " + this.excludeFromSrc + ")";
    }

    public Field(String field, FieldType type, String analyzer, Boolean docValues, Boolean indexed, Boolean stored, Boolean hasFields, MapResult.ImmutableResult argsMap, List<String> copyToFields, Map<String, Field> properties, boolean excludeFromSrc) {
        this.field = field;
        this.type = type;
        this.analyzer = analyzer;
        this.docValues = docValues;
        this.indexed = indexed;
        this.stored = stored;
        this.hasFields = hasFields;
        this.argsMap = argsMap;
        this.copyToFields = copyToFields;
        this.properties = properties;
        this.excludeFromSrc = excludeFromSrc;
    }

    public String field() {
        return this.field;
    }

    public boolean excludeFromSrc() {
        return this.excludeFromSrc;
    }

    public static class FieldBuilder
    implements Comparable<FieldBuilder> {
        @NonNull
        private final String field;
        @NonNull
        private final FieldType type;
        private String analyzer = null;
        private Boolean docValues = null;
        private Boolean indexed = null;
        private Boolean stored = null;
        private Boolean hasFields = null;
        private final SortedMapResult args = SortedMapResult.treeResult();
        private final ListBuilder.ImmutableListBuilder<String> copyToFields = ListBuilder.immutableListBuilder();
        private final MapBuilder.ImmutableMapBuilder<String, FieldBuilder> properties = MapBuilder.immutableMapBuilder();
        private boolean excludeFromSrc = false;

        @Override
        public int compareTo(FieldBuilder other) {
            return other == null ? -1 : this.field.compareTo(other.field);
        }

        public FieldBuilder mapping(FieldBuilder mapping) {
            this.properties.put((Object)mapping.field, (Object)mapping);
            return this;
        }

        public FieldBuilder properties(Collection<FieldBuilder> builders) {
            builders.forEach(this::mapping);
            return this;
        }

        public FieldBuilder properties(Map<String, FieldBuilder> builders) {
            this.properties.putAll(builders);
            return this;
        }

        public FieldBuilder isAPath() {
            return this.addField("tree", "path");
        }

        public FieldBuilder normalise() {
            return this.addField("text", "norm");
        }

        public FieldBuilder addRawFields() {
            this.hasFields(true);
            return this.mapping(Field.keywordField("raw"));
        }

        public FieldBuilder addField(String field, String analyzer) {
            this.hasFields(true);
            return this.mapping(Field.textField(field, analyzer));
        }

        public FieldBuilder addField(String field, Map<String, Object> props) {
            FieldBuilder subField = Field.textField(field, MapRetriever.reqdStr(props, (String)"analyzer"));
            props.forEach((k, v) -> {
                if (!"analyzer".equals(k)) {
                    subField.args.put(k, v);
                }
            });
            this.hasFields(true);
            return this.mapping(subField);
        }

        public FieldBuilder dynamic(Object value) {
            if (value != null) {
                this.args.put((Object)"dynamic", value);
            }
            return this;
        }

        public FieldBuilder scaling(double value) {
            this.args.put((Object)"scaling_factor", (Object)value);
            return this;
        }

        public FieldBuilder format(String value) {
            if (value != null) {
                this.args.put((Object)"format", (Object)value);
            }
            return this;
        }

        public FieldBuilder quadtree() {
            this.args.put((Object)"tree", (Object)"quadtree");
            return this;
        }

        public FieldBuilder disabled() {
            this.args.put((Object)"enabled", (Object)false);
            return this;
        }

        public FieldBuilder disableOrDynamic(Boolean disable) {
            if (disable != null) {
                return disable != false ? this.disabled() : this.dynamic("true");
            }
            return this;
        }

        public FieldBuilder extra(String name, Object value) {
            if (value != null) {
                this.args.put((Object)name, value);
            }
            return this;
        }

        public FieldBuilder copyTo(String value) {
            if (value != null) {
                this.copyToFields.add((Object)value);
            }
            return this;
        }

        public FieldBuilder copyToFields(Collection<String> copyFields) {
            this.copyToFields.addAll(copyFields);
            return this;
        }

        public FieldBuilder arg(String key, Object value) {
            this.args.put((Object)key, value);
            return this;
        }

        public FieldBuilder args(Map<String, Object> args) {
            this.args.putAll(args);
            return this;
        }

        public FieldBuilder duplicate(String newField) {
            return Field.fieldBuilder(newField, this.type).analyzer(this.analyzer).docValues(this.docValues).indexed(this.indexed).stored(this.stored).hasFields(this.hasFields).copyToFields((Collection<String>)this.copyToFields.build()).args((Map<String, Object>)this.args).properties((Map<String, FieldBuilder>)this.properties.build());
        }

        public Field build() {
            return new Field(this.field, this.type, this.analyzer, this.docValues, this.indexed, this.stored, this.hasFields, (MapResult.ImmutableResult)this.args.immutable(), (List<String>)this.copyToFields.build(), CollUtil.uniqueIndex((Iterable)CollUtil.transform((Iterable)this.properties.build().values(), FieldBuilder::build), Field::field), this.excludeFromSrc);
        }

        private FieldBuilder(@NonNull String field, @NonNull FieldType type) {
            if (field == null) {
                throw new NullPointerException("field is marked @NonNull but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.field = field;
            this.type = type;
        }

        @NonNull
        public String field() {
            return this.field;
        }

        @NonNull
        public FieldType type() {
            return this.type;
        }

        private FieldBuilder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public FieldBuilder docValues(Boolean docValues) {
            this.docValues = docValues;
            return this;
        }

        public FieldBuilder indexed(Boolean indexed) {
            this.indexed = indexed;
            return this;
        }

        public FieldBuilder stored(Boolean stored) {
            this.stored = stored;
            return this;
        }

        private FieldBuilder hasFields(Boolean hasFields) {
            this.hasFields = hasFields;
            return this;
        }

        public FieldBuilder excludeFromSrc(boolean excludeFromSrc) {
            this.excludeFromSrc = excludeFromSrc;
            return this;
        }
    }
}

