package io.polyglotted.elastic.index;

import io.polyglotted.common.model.Jsoner;
import io.polyglotted.common.model.MapResult;
import lombok.SneakyThrows;
import org.elasticsearch.common.Strings;

import static io.polyglotted.common.util.BaseSerializer.serialize;
import static io.polyglotted.common.util.MapBuilder.immutableMap;
import static io.polyglotted.elastic.common.MetaFields.ID_FIELD;
import static io.polyglotted.elastic.common.MetaFields.KEY_FIELD;
import static io.polyglotted.elastic.common.MetaFields.MODEL_FIELD;
import static io.polyglotted.elastic.common.MetaFields.RESULT_FIELD;
import static io.polyglotted.elastic.common.MetaFields.TIMESTAMP_FIELD;
import static io.polyglotted.elastic.common.MetaFields.model;
import static io.polyglotted.elastic.common.MetaFields.reqdId;
import static io.polyglotted.elastic.common.MetaFields.reqdKey;
import static io.polyglotted.elastic.common.MetaFields.timestamp;
import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

@SuppressWarnings({"serial", "unused", "WeakerAccess"})
public final class NoopException extends RuntimeException implements Jsoner {
    private final String id;

    public NoopException(MapResult current) { super(buildMessage(current)); this.id = reqdId(current); }

    @Override public String toJson() { return "{\"" + id + "\":" + getMessage() + "}"; }

    @SneakyThrows private static String buildMessage(MapResult current) {
        return Strings.toString(jsonBuilder().startObject().field(ID_FIELD, reqdId(current)).field(KEY_FIELD, reqdKey(current))
            .field(MODEL_FIELD, model(current)).field(RESULT_FIELD, "noop").field(TIMESTAMP_FIELD, timestamp(current)).endObject());
    }

    public static String jsonMsg(Exception ex) {
        return ex instanceof NoopException ? ex.getMessage() : serialize(immutableMap("error", ex.getMessage()));
    }

    public static String jsonResult(Exception ex) {
        return ex instanceof NoopException ? ((NoopException) ex).toJson() : serialize(immutableMap("error", ex.getMessage()));
    }
}