/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.search.ExprConverter;
import io.polyglotted.elastic.search.Expression;
import io.polyglotted.elastic.search.WrapperModule;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryMaker {
    private static final Logger log = LoggerFactory.getLogger(QueryMaker.class);
    public static final int DEFAULT_MAXIMUM = 10000;
    public static final TimeValue DEFAULT_KEEP_ALIVE = TimeValue.timeValueMinutes((long)5L);
    private static final WrapperModule searchModule = new WrapperModule();

    public static SearchRequest copyFrom(String repo, byte[] bytes, Verbose verbose) {
        return QueryMaker.copyFrom(repo, bytes, null, verbose);
    }

    public static SearchRequest copyFrom(String repo, byte[] bytes, Long scroll, Verbose verbose) {
        SearchSourceBuilder src;
        String[] stringArray;
        if (repo == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = repo;
        }
        SearchRequest request = new SearchRequest(stringArray);
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        if (scroll != null) {
            request.scroll(TimeValue.timeValueMillis((long)scroll));
        }
        if ((src = searchModule.sourceFrom(bytes)).fetchSource() != null) {
            String[] includes = src.fetchSource().includes();
            String[] excludes = src.fetchSource().excludes();
            src.fetchSource(new FetchSourceContext(true, verbose.includeFields(includes), excludes));
        }
        request.source(src);
        return QueryMaker.trace(request);
    }

    public static SearchRequest aggregationToRequest(String repo, AggregationBuilder builder) {
        SearchSourceBuilder source = new SearchSourceBuilder().size(0).query((QueryBuilder)QueryBuilders.matchAllQuery()).aggregation(builder);
        return QueryMaker.trace(new SearchRequest(new String[]{repo}).indicesOptions(IndicesOptions.lenientExpandOpen()).source(source));
    }

    public static SearchRequest filterToScroller(String repo, Expression filter, int size) {
        return QueryMaker.filterToRequest(repo, filter, FetchSourceContext.FETCH_SOURCE, ListBuilder.immutableList(), size).scroll(DEFAULT_KEEP_ALIVE);
    }

    public static SearchRequest filterToRequest(String repo, Expression filter, FetchSourceContext context, List<SortBuilder<?>> sorts, int size) {
        SearchSourceBuilder source = new SearchSourceBuilder().size(size).query((QueryBuilder)NullUtil.nonNull((Object)ExprConverter.buildFilter(filter), (Object)QueryBuilders.matchAllQuery())).fetchSource(context);
        for (SortBuilder<?> sort : sorts) {
            source.sort(sort);
        }
        return QueryMaker.trace(new SearchRequest(new String[]{repo}).indicesOptions(IndicesOptions.lenientExpandOpen()).source(source));
    }

    public static SearchScrollRequest scrollRequest(String scrollId, TimeValue scrollTime) {
        return new SearchScrollRequest(scrollId).scroll(scrollTime);
    }

    private static SearchRequest trace(SearchRequest searchRequest) {
        if (log.isDebugEnabled()) {
            log.debug(searchRequest.source().toString());
        }
        return searchRequest;
    }
}

