/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.StrUtil;
import java.util.List;
import java.util.Objects;

public final class Expression {
    static final Expression NilExpression = new Expression("_nil_", "_nil_", (MapResult.ImmutableResult)MapResult.immutableResult());
    static final String ValueKey = "_val";
    public final String operation;
    public final String label;
    public final MapResult.ImmutableResult args;

    static Expression withMap(String operation, String label, MapResult.ImmutableResult args) {
        return new Expression(Objects.requireNonNull(operation), Objects.requireNonNull(label), args);
    }

    static Expression withValue(String expressionType, String label, Object valueArg) {
        return new Expression(expressionType, Objects.requireNonNull(label), (MapResult.ImmutableResult)MapResult.immutableResult((String)ValueKey, (Object)valueArg));
    }

    static <E extends Comparable<E>> Expression withArray(String expressionType, String label, List<E> valueArg) {
        return new Expression(expressionType, Objects.requireNonNull(label), (MapResult.ImmutableResult)MapResult.immutableResult((String)ValueKey, valueArg));
    }

    static Expression withLabel(String expressionType, String label) {
        return new Expression(expressionType, Objects.requireNonNull(label), (MapResult.ImmutableResult)MapResult.immutableResult());
    }

    <T> T valueArg() {
        return this.argFor(ValueKey, null);
    }

    List<Object> arrayArg() {
        return (List)this.argFor(ValueKey, ListBuilder.immutableList());
    }

    String stringArg(String key) {
        return this.argFor(key, null);
    }

    <T> T argFor(String key) {
        return Objects.requireNonNull(this.argFor(key, null));
    }

    private <T> T argFor(String key, T defValue) {
        return (T)(this.args.containsKey((Object)key) ? this.args.get((Object)key) : defValue);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && BaseSerializer.serialize((Object)this).equals(BaseSerializer.serialize((Object)o));
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.label, this.args);
    }

    public String toString() {
        return (StrUtil.nullOrEmpty((String)this.label) ? "" : this.label + " ") + this.operation + (this.args.isEmpty() ? "" : " " + this.args);
    }

    public Expression(String operation, String label, MapResult.ImmutableResult args) {
        this.operation = operation;
        this.label = label;
        this.args = args;
    }
}

