/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.SortedMapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.elastic.search.Bucket;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Aggregation {
    public final String label;
    public final String type;
    public final Object value;
    public final MapResult parameters;

    public boolean hasBuckets() {
        return AggregationType.valueOf((String)this.type).hasBuckets;
    }

    public List<Bucket> buckets() {
        Assertions.checkBool((boolean)this.hasBuckets(), (String)(this.type + " does not support buckets"));
        return (List)this.value;
    }

    public Map<String, Long> bucketCounts() {
        MapBuilder.ImmutableMapBuilder bucketCounts = MapBuilder.immutableMapBuilder();
        for (Bucket bucket : this.buckets()) {
            bucketCounts.put((Object)String.valueOf(bucket.value), (Object)bucket.count);
        }
        return bucketCounts.build();
    }

    public <T> T param(String name, Class<T> tClass) {
        return tClass.cast(this.parameters.get((Object)name));
    }

    public long longValue(String name) {
        return this.value(name, Long.class);
    }

    public double doubleValue(String name) {
        return this.value(name, Double.class);
    }

    public <T> T value(String name, Class<T> tClass) {
        return this.value instanceof Map ? tClass.cast(((Map)this.value).get(name)) : tClass.cast(this.value);
    }

    public Iterable<Map.Entry<String, Object>> valueIterable() {
        return this.value instanceof Map ? ((Map)this.value).entrySet() : ListBuilder.immutableList((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, Object>("value", this.value)});
    }

    public static Builder deserializeAgg(MapResult result) {
        AggregationType aggType = AggregationType.valueOf(MapRetriever.reqdStr((Map)result, (String)"type"));
        Builder builder = Aggregation.aggregationBuilder().label(MapRetriever.reqdStr((Map)result, (String)"label")).type(aggType).params(MapRetriever.mapVal((Map)result, (String)"parameters"));
        aggType.deserValue(result, builder);
        return builder;
    }

    public static Builder aggregationBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Aggregation(" + this.label + ", " + this.type + ", " + this.value + ")";
    }

    public Aggregation(String label, String type, Object value, MapResult parameters) {
        this.label = label;
        this.type = type;
        this.value = value;
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Aggregation)) {
            return false;
        }
        Aggregation other = (Aggregation)o;
        String this$label = this.label;
        String other$label = other.label;
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$value = this.value;
        Object other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        MapResult this$parameters = this.parameters;
        MapResult other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.label;
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        MapResult $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        return result;
    }

    public static enum AggregationType {
        Max(false, false),
        Min(false, false),
        Sum(false, false),
        Avg(false, false),
        Count(false, false),
        ExtStatistics(false, true),
        Statistics(false, true),
        Term(true, false),
        DateHistogram(true, false),
        Filter(true, false),
        Children(true, false),
        Nested(true, false),
        ReverseNested(true, false),
        Cardinality(false, false);

        public final boolean hasBuckets;
        public final boolean isMultiValue;

        final <T> T valueFrom(MapResult valueMap, Iterable<Bucket> buckets) {
            return (T)(this.hasBuckets ? ListBuilder.immutableList(buckets) : (this.isMultiValue ? MapResult.immutableResult((Map)valueMap) : valueMap.get((Object)this.name())));
        }

        void deserValue(MapResult result, Builder builder) {
            if (this.hasBuckets) {
                List buckets = MapRetriever.listVal((Map)result, (String)"value");
                for (MapResult bucket : buckets) {
                    builder.bucket(Bucket.deserializeBucket(bucket));
                }
            } else if (this.isMultiValue) {
                builder.values(MapRetriever.mapVal((Map)result, (String)"value"));
            } else {
                builder.value(this.name(), MapRetriever.reqdValue((Map)result, (String)"value"));
            }
        }

        private AggregationType(boolean hasBuckets, boolean isMultiValue) {
            this.hasBuckets = hasBuckets;
            this.isMultiValue = isMultiValue;
        }
    }

    public static class Builder {
        private String label;
        private AggregationType type;
        private final MapResult valueMap = SortedMapResult.treeResult();
        private final MapResult paramsMap = SortedMapResult.treeResult();
        private final List<Bucket.Builder> builders = ListBuilder.simpleList();

        public Builder value(String key, Object value) {
            this.valueMap.put((Object)key, value);
            return this;
        }

        public void values(Map<String, Object> values) {
            this.valueMap.putAll(values);
        }

        public Builder param(String key, Object value) {
            this.paramsMap.put((Object)key, value);
            return this;
        }

        public Builder params(Map<String, Object> params) {
            this.paramsMap.putAll(params);
            return this;
        }

        public Bucket.Builder bucketBuilder() {
            Bucket.Builder builder = Bucket.bucketBuilder();
            this.builders.add(builder);
            return builder;
        }

        public void bucket(Bucket.Builder builder) {
            this.builders.add(builder);
        }

        public Aggregation build() {
            return new Aggregation(Objects.requireNonNull(this.label, "label is required"), Objects.requireNonNull(this.type, "type is required").name(), this.type.valueFrom(this.valueMap, (Iterable<Bucket>)CollUtil.transform(this.builders, Bucket.Builder::build)), (MapResult)MapResult.immutableResult((Map)this.paramsMap));
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder type(AggregationType type) {
            this.type = type;
            return this;
        }

        private Builder() {
        }
    }
}

