/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.model.Jsoner;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.SortedMapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ResourceUtil;
import java.util.Map;

public final class IndexSetting
implements Jsoner {
    private static final String DEF_ANALYSIS = ResourceUtil.readResource(IndexSetting.class, (String)"def-analysis.json");
    public final MapResult.ImmutableResult mapResult;

    public String toJson() {
        return BaseSerializer.serialize((Object)CollUtil.filterKeysNeg((Map)this.mapResult, "index_name"::equals));
    }

    public static IndexSetting settingFrom(Map<String, Object> map) {
        return new IndexSetting((MapResult.ImmutableResult)MapResult.immutableResult(map));
    }

    public static IndexSetting with(int numberOfShards, int numberOfReplicas) {
        return IndexSetting.settingBuilder(numberOfShards, numberOfReplicas).build();
    }

    public static IndexSetting autoReplicate() {
        return IndexSetting.autoReplicate(DEF_ANALYSIS);
    }

    public static IndexSetting autoReplicate(String analysis) {
        return IndexSetting.settingBuilder().numberOfShards(1).autoExpandReplicas().analysis(analysis).ignoreMalformed().refreshInterval(-1L).build();
    }

    public static Builder settingBuilder(int numShards, int numReplicas) {
        return IndexSetting.settingBuilder(numShards, numReplicas, DEF_ANALYSIS);
    }

    public static Builder settingBuilder(int numShards, int numReplicas, String analysis) {
        return IndexSetting.settingBuilder().analysis((String)NullUtil.nonNull((Object)analysis, (Object)DEF_ANALYSIS)).numberOfShards(numShards).numberOfReplicas(numReplicas).refreshInterval(-1L).ignoreMalformed();
    }

    public static Builder settingBuilder() {
        return new Builder();
    }

    public IndexSetting(MapResult.ImmutableResult mapResult) {
        this.mapResult = mapResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSetting)) {
            return false;
        }
        IndexSetting other = (IndexSetting)o;
        MapResult.ImmutableResult this$mapResult = this.mapResult;
        MapResult.ImmutableResult other$mapResult = other.mapResult;
        return !(this$mapResult == null ? other$mapResult != null : !this$mapResult.equals(other$mapResult));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MapResult.ImmutableResult $mapResult = this.mapResult;
        result = result * 59 + ($mapResult == null ? 43 : $mapResult.hashCode());
        return result;
    }

    public static class Builder {
        private final SortedMapResult treeResult = SortedMapResult.treeResult();

        public Builder numberOfShards(int numberOfShards) {
            return this.any("number_of_shards", numberOfShards);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            return this.any("number_of_replicas", numberOfReplicas);
        }

        public Builder refreshInterval(long refreshInterval) {
            return this.any("refresh_interval", refreshInterval);
        }

        public Builder ignoreMalformed() {
            this.treeResult.putIfAbsent((Object)"mapping.ignore_malformed", (Object)true);
            return this;
        }

        public Builder autoExpandReplicas() {
            this.treeResult.putIfAbsent((Object)"auto_expand_replicas", (Object)"0-all");
            return this;
        }

        public Builder totalFields(Integer totalFieldsCount) {
            return this.any("mapping.total_fields.limit", totalFieldsCount);
        }

        public Builder nestedFields(Integer nestedFieldsCount) {
            return this.any("mapping.nested_fields.limit", nestedFieldsCount);
        }

        public Builder any(String name, Object value) {
            this.treeResult.put((Object)name, value);
            return this;
        }

        public Builder all(MapResult result) {
            this.treeResult.putAll((Map)result);
            return this;
        }

        public Builder analysis(String analysis) {
            return this.any("analysis", BaseSerializer.deserialize((String)analysis));
        }

        public IndexSetting build() {
            return new IndexSetting((MapResult.ImmutableResult)this.treeResult.immutable());
        }

        private Builder() {
        }
    }
}

