/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.admin.Field;
import java.util.EnumSet;
import java.util.Map;

public enum FieldType {
    BINARY(true, true, false),
    BOOLEAN(true, true, true),
    DATE(true, true, true),
    GEO_POINT(false, false, false),
    GEO_SHAPE(false, false, false),
    IP(true, true, true),
    DOUBLE(true, true, true),
    FLOAT(true, true, true),
    HALF_FLOAT(true, true, true),
    SCALED_FLOAT(true, true, true),
    BYTE(true, true, true),
    SHORT(true, true, true),
    INTEGER(true, true, true),
    LONG(true, true, true),
    KEYWORD(true, true, true),
    TEXT(false, true, true),
    NESTED(false, false, false),
    OBJECT(false, false, false),
    JOIN(false, false, false);

    private final boolean docValues;
    private final boolean storable;
    private final boolean indexable;
    private static final EnumSet<FieldType> SIMPLE_FIELDS;
    private static final Map<String, FieldType> TYPES;

    public static FieldType fieldType(String value) {
        return TYPES.get(value);
    }

    FieldType simpleField() {
        return (FieldType)((Object)Assertions.checkContains(SIMPLE_FIELDS, (Object)((Object)this), (String)(this.name() + " not a simple type")));
    }

    String validate(Field field) {
        Assertions.checkBool((this.docValues || field.docValues == null ? 1 : 0) != 0, (String)("field " + field.field + " with type " + this.name() + " cannot contain docValues"));
        Assertions.checkBool((this.storable || field.stored == null ? 1 : 0) != 0, (String)("field " + field.field + " with type " + this.name() + " cannot be stored"));
        Assertions.checkBool((this.indexable || field.indexed == null ? 1 : 0) != 0, (String)("field " + field.field + " with type " + this.name() + " cannot be indexed"));
        return this.name().toLowerCase();
    }

    private FieldType(boolean docValues, boolean storable, boolean indexable) {
        this.docValues = docValues;
        this.storable = storable;
        this.indexable = indexable;
    }

    static {
        SIMPLE_FIELDS = EnumSet.of(BINARY, new FieldType[]{BOOLEAN, DATE, GEO_POINT, GEO_SHAPE, IP, DOUBLE, FLOAT, HALF_FLOAT, SCALED_FLOAT, BYTE, SHORT, INTEGER, LONG, KEYWORD});
        MapBuilder.ImmutableMapBuilder builder = MapBuilder.immutableMapBuilder();
        for (FieldType type : FieldType.values()) {
            builder.put((Object)type.name(), (Object)type).put((Object)type.name().toLowerCase(), (Object)type);
        }
        TYPES = builder.build();
    }
}

