/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.TokenUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.XPackApi;
import io.polyglotted.elastic.common.DocResult;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.Indexer;
import io.polyglotted.elastic.index.Validator;
import io.polyglotted.elastic.search.ResultBuilder;
import io.polyglotted.elastic.search.Searcher;
import org.apache.commons.codec.binary.Base64;

public abstract class UserUtil {
    public static String writeUser(Indexer indexer, Searcher searcher, AuthHeader esAuth, String userRepo, String userModel, final String userId, final MapResult user, String subject, long millis) {
        user.remove((Object)"password");
        MapResult newValue = MapResult.simpleResult((String)"body", (Object)new String(Base64.encodeBase64((byte[])BaseSerializer.serializeBytes((Object)user)), "utf-8"), (String)"id", (Object)userId);
        final MapResult existing = UserUtil.findMeta(searcher, esAuth, userRepo, userModel, userId);
        if (existing != null && newValue.equals(DocResult.filtered(existing))) {
            return BaseSerializer.serialize((Object)MetaFields.readKey(existing).put((Object)"&result", (Object)"noop").build());
        }
        return UserUtil.indexMeta(indexer, existing, userRepo, userModel, userId, newValue, esAuth, subject, millis, new Validator.StrictValidator(){

            @Override
            protected void preValidate(ElasticClient client, IndexRecord record) {
                if (existing == null) {
                    user.put((Object)"password", (Object)TokenUtil.uniqueToken());
                }
                client.xpackPut(XPackApi.USER, userId, BaseSerializer.serialize((Object)user));
            }
        });
    }

    public static void putPasswd(ElasticClient client, String userId, String password) {
        client.xpackPut(XPackApi.PASSWD, userId, BaseSerializer.serialize((Object)MapBuilder.immutableMap((Object)"password", (Object)password)));
    }

    private static String indexMeta(Indexer indexer, Object existing, String repo, String model, String id, Object newValue, AuthHeader esAuth, String userId, long millis, Validator validator) {
        IndexRecord.Builder record = (existing == null ? IndexRecord.createRecord(repo, model, id, newValue) : IndexRecord.updateRecord(repo, model, id, MetaFields.timestamp(existing), newValue)).user(userId).timestamp(millis);
        return indexer.strictSave(esAuth, record.build(), validator);
    }

    private static MapResult findMeta(Searcher searcher, AuthHeader esAuth, String repo, String model, String id) {
        return searcher.getById(esAuth, repo, model, id, ResultBuilder.SourceBuilder, Verbose.META);
    }
}

