/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.discovery;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import io.polyglotted.elastic.discovery.Ec2Service;
import java.util.Random;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Ec2ServiceImpl
implements Ec2Service {
    private static final Logger log = LoggerFactory.getLogger(Ec2ServiceImpl.class);

    Ec2ServiceImpl() {
    }

    static AmazonEC2 client(Settings settings) {
        AmazonEC2ClientBuilder builder = (AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2Client.builder().withCredentials(Ec2ServiceImpl.buildCredentials(settings))).withClientConfiguration(Ec2ServiceImpl.buildConfiguration(settings));
        if (REGION_SETTING.exists(settings)) {
            String endpoint = Ec2ServiceImpl.findEndpoint(settings);
            if (endpoint != null) {
                builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, (String)REGION_SETTING.get(settings)));
            } else {
                builder.withRegion(Regions.fromName((String)((String)REGION_SETTING.get(settings))));
            }
        } else {
            builder.withRegion(Regions.EU_WEST_1);
        }
        return (AmazonEC2)builder.build();
    }

    private static AWSCredentialsProvider buildCredentials(Settings settings) {
        DefaultAWSCredentialsProviderChain credentials;
        try (SecureString key = (SecureString)ACCESS_KEY_SETTING.get(settings);
             SecureString secret = (SecureString)SECRET_KEY_SETTING.get(settings);){
            if (key.length() == 0 && secret.length() == 0) {
                log.debug("Using either environment variables, system properties or instance profile credentials");
                credentials = new DefaultAWSCredentialsProviderChain();
            } else {
                log.debug("Using basic key/secret credentials");
                credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key.toString(), secret.toString()));
            }
        }
        return credentials;
    }

    private static ClientConfiguration buildConfiguration(Settings settings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol((Protocol)PROTOCOL_SETTING.get(settings));
        if (PROXY_HOST_SETTING.exists(settings)) {
            String proxyHost = (String)PROXY_HOST_SETTING.get(settings);
            Integer proxyPort = (Integer)PROXY_PORT_SETTING.get(settings);
            try (SecureString proxyUsername = (SecureString)PROXY_USERNAME_SETTING.get(settings);
                 SecureString proxyPassword = (SecureString)PROXY_PASSWORD_SETTING.get(settings);){
                clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername.toString()).withProxyPassword(proxyPassword.toString());
            }
        }
        Random rand = Randomness.get();
        RetryPolicy retryPolicy = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, (originalRequest, exception, retriesAttempted) -> {
            log.warn("EC2 API request failed, retry again. Reason was:", (Throwable)exception);
            return 1000L * (long)(10.0 * Math.pow(2.0, (double)retriesAttempted / 2.0) * (1.0 + rand.nextDouble()));
        }, 10, false);
        clientConfiguration.setRetryPolicy(retryPolicy);
        clientConfiguration.setSocketTimeout((int)((TimeValue)READ_TIMEOUT_SETTING.get(settings)).millis());
        return clientConfiguration;
    }

    private static String findEndpoint(Settings settings) {
        String endpoint = null;
        if (ENDPOINT_SETTING.exists(settings)) {
            endpoint = (String)ENDPOINT_SETTING.get(settings);
            log.debug("using explicit ec2 endpoint [{}]", (Object)endpoint);
        }
        return endpoint;
    }
}

