/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.discovery;

import com.amazonaws.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;

interface Ec2Service {
    public static final Setting<String> REGION_SETTING = new Setting("cloud.aws.region", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.secureString((String)"discovery.ec2.access_key", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.secureString((String)"discovery.ec2.secret_key", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<String> ENDPOINT_SETTING = new Setting("discovery.ec2.endpoint", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Protocol> PROTOCOL_SETTING = new Setting("discovery.ec2.protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString((String)"discovery.ec2.proxy.host", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting((String)"discovery.ec2.proxy.port", (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<SecureString> PROXY_USERNAME_SETTING = SecureSetting.secureString((String)"discovery.ec2.proxy.username", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> PROXY_PASSWORD_SETTING = SecureSetting.secureString((String)"discovery.ec2.proxy.password", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting((String)"discovery.ec2.read_timeout", (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> HOST_TYPE_SETTING = new Setting("discovery.ec2.host_type", "private_ip", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ANY_GROUP_SETTING = Setting.boolSetting((String)"discovery.ec2.any_group", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> GROUPS_SETTING = Setting.listSetting((String)"discovery.ec2.groups", new ArrayList(), String::toString, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> AVAILABILITY_ZONES_SETTING = Setting.listSetting((String)"discovery.ec2.availability_zones", Collections.emptyList(), String::toString, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting.AffixSetting<List<String>> TAG_SETTING = Setting.prefixKeySetting((String)"discovery.ec2.tag.", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    public static class HostType {
        static final String PRIVATE_IP = "private_ip";
        static final String PUBLIC_IP = "public_ip";
        static final String PRIVATE_DNS = "private_dns";
        static final String PUBLIC_DNS = "public_dns";
        static final String TAG_PREFIX = "tag:";
    }
}

