/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.CommaUtil;
import io.polyglotted.common.util.InsecureSslFactory;
import io.polyglotted.common.util.ResourceUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.ElasticRestClient;
import io.polyglotted.elastic.client.ElasticSettings;
import io.polyglotted.elastic.discovery.UnicastHostsProvider;
import java.io.IOException;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.settings.Settings;

public class HighLevelConnector {
    public static ElasticClient highLevelClient(ElasticSettings settings) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])HighLevelConnector.buildHosts(settings)).setMaxRetryTimeoutMillis(settings.retryTimeoutMillis);
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(settings.connectTimeoutMillis).setSocketTimeout(settings.socketTimeoutMillis));
        if (settings.insecure) {
            restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(InsecureSslFactory.insecureSslContext((String)settings.host, (int)settings.port)).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()));
        } else {
            restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(HighLevelConnector.predeterminedContext()).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()));
        }
        return new ElasticRestClient(restClientBuilder, settings.bootstrapAuth());
    }

    private static SSLContext predeterminedContext() {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(ResourceUtil.urlStream(HighLevelConnector.class, (String)"elastic-stack-ca.p12"), new char[0]);
        return SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
    }

    private static HttpHost[] buildHosts(ElasticSettings settings) throws IOException {
        List hosts = "ec2".equals(System.getProperty("es.discovery.zen.hosts_provider", "")) ? UnicastHostsProvider.fetchEc2Addresses(HighLevelConnector.buildEsSettings()) : CommaUtil.commaSplit((String)settings.host);
        return (HttpHost[])CollUtil.transform((Iterable)hosts, node -> new HttpHost(Objects.requireNonNull(node), settings.port, settings.scheme)).toArray(HttpHost.class);
    }

    private static Settings buildEsSettings() {
        Settings.Builder builder = Settings.builder();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String key = String.valueOf(e.getKey());
            if (!key.startsWith("es.")) continue;
            builder.put(key.substring(3), String.valueOf(e.getValue()));
        }
        return builder.build();
    }
}

