/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.HttpRequestBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.common.util.ThreadUtil;
import io.polyglotted.elastic.admin.Type;
import io.polyglotted.elastic.admin.TypeSerializer;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.ElasticException;
import io.polyglotted.elastic.client.XPackApi;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticRestClient
implements ElasticClient {
    private final RestHighLevelClient internalClient;
    @Nullable
    private final AuthHeader bootstrapAuth;

    ElasticRestClient(RestClientBuilder builder, AuthHeader bootstrapAuth) {
        this(new RestHighLevelClient(builder), bootstrapAuth);
    }

    @Override
    public void close() {
        this.internalClient.close();
    }

    @Override
    public ElasticClient waitForStatus(AuthHeader auth, String status) {
        try {
            int i = 0;
            if (i <= 300) {
                this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, "/_cluster/health?wait_for_status=" + status);
            }
        }
        catch (ConnectException | ConnectionClosedException retry) {
            ThreadUtil.safeSleep((long)1000L);
            this.waitForStatus(auth, status);
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("waitForStatus failed", ioe);
        }
        return this;
    }

    @Override
    public MapResult clusterHealth(AuthHeader auth) {
        return BaseSerializer.deserialize((String)this.simpleGet(auth, "/_cluster/health", "clusterHealth"));
    }

    @Override
    public boolean indexExists(AuthHeader auth, String repo) {
        try {
            return this.internalClient.getLowLevelClient().performRequest("HEAD", "/" + repo, this.headers(auth)).getStatusLine().getStatusCode() == 200;
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("indexExists failed", ioe);
        }
    }

    @Override
    public MapResult indexNameFor(AuthHeader auth, String alias) {
        MapBuilder.ImmutableMapBuilder result = MapBuilder.immutableMapBuilder();
        try {
            List list = BaseSerializer.deserializeToList((String)this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, "/_cat/aliases" + (StrUtil.notNullOrEmpty((String)alias) ? "/" + alias : "") + "?h=index,alias&format=json"));
            for (Map map : list) {
                result.put((Object)MapRetriever.reqdStr((Map)map, (String)"alias"), (Object)MapRetriever.reqdStr((Map)map, (String)"index"));
            }
            return result.result();
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("indexNameFor failed", ioe);
        }
    }

    @Override
    public String createIndex(AuthHeader auth, CreateIndexRequest request) {
        try {
            CreateIndexResponse response = this.internalClient.indices().create(request, this.headers(auth));
            ElasticException.checkState(response.isAcknowledged() && response.isShardsAcknowledged(), "unable to create index");
            return request.index();
        }
        catch (Exception e) {
            throw ElasticException.throwEx("createIndex failed", e);
        }
    }

    @Override
    public void dropIndex(AuthHeader auth, String index) {
        try {
            DeleteIndexResponse response = this.internalClient.indices().delete(new DeleteIndexRequest(index), this.headers(auth));
            ElasticException.checkState(response.isAcknowledged(), "unable to drop index");
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("dropIndex failed", ioe);
        }
    }

    @Override
    public void forceRefresh(AuthHeader auth, String repo) {
        try {
            this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.POST, "/" + repo + "/_refresh");
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("forceRefresh failed", ioe);
        }
    }

    @Override
    public String getSettings(AuthHeader auth, String repo) {
        return this.simpleGet(auth, "/" + repo + "/_settings", "getSettings");
    }

    @Override
    public MapResult putMapping(AuthHeader auth, String index, Type update) {
        try {
            return BaseSerializer.deserialize((String)this.simplePut(auth, HttpRequestBuilder.HttpReqType.PUT, "/" + index + "/_mapping/_doc", TypeSerializer.serializeMapping(update), "putMapping"));
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("putMapping failed", ioe);
        }
    }

    @Override
    public MapResult.ImmutableResult getMapping(AuthHeader auth, String repo) {
        try {
            MapResult result = BaseSerializer.deserialize((String)this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, "/" + repo + "/_mapping/_doc"));
            return MapResult.immutableResult((Map)MapRetriever.mapVal((Map)MapRetriever.asMap((Object)result.first()), (String)"mappings"));
        }
        catch (Exception e) {
            throw ElasticException.throwEx("getMapping failed", e);
        }
    }

    @Override
    public void putPipeline(AuthHeader auth, String id, String body) {
        this.simplePut(auth, HttpRequestBuilder.HttpReqType.PUT, "/_ingest/pipeline/" + id, body, "putPipeline");
    }

    @Override
    public boolean pipelineExists(AuthHeader auth, String id) {
        return this.simpleGet(auth, "/_ingest/pipeline/" + id, "pipelineExists") != null;
    }

    @Override
    public void deletePipeline(AuthHeader auth, String id) {
        this.simpleDelete(auth, "/_ingest/pipeline/" + id, "deletePipeline");
    }

    @Override
    public void putTemplate(AuthHeader auth, String name, String body) {
        this.simplePut(auth, HttpRequestBuilder.HttpReqType.PUT, "/_template/" + name, body, "putTemplate");
    }

    @Override
    public boolean templateExists(AuthHeader auth, String name) {
        return this.simpleGet(auth, "/_template/" + name, "templateExists") != null;
    }

    @Override
    public void deleteTemplate(AuthHeader auth, String name) {
        this.simpleDelete(auth, "/_template/" + name, "deleteTemplate");
    }

    @Override
    public IndexResponse index(AuthHeader auth, IndexRequest request) {
        try {
            return this.internalClient.index(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("index failed", ioe);
        }
    }

    @Override
    public DeleteResponse delete(AuthHeader auth, DeleteRequest request) {
        try {
            return this.internalClient.delete(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("delete failed", ioe);
        }
    }

    @Override
    public BulkResponse bulk(AuthHeader auth, BulkRequest request) {
        try {
            return this.internalClient.bulk(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("bulk failed", ioe);
        }
    }

    @Override
    public void bulkAsync(AuthHeader auth, BulkRequest request, ActionListener<BulkResponse> listener) {
        try {
            this.internalClient.bulkAsync(request, listener, this.headers(auth));
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx("bulkAsync failed", ioe);
        }
    }

    @Override
    public boolean exists(AuthHeader auth, GetRequest request) {
        try {
            return this.internalClient.exists(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("exists failed", ioe);
        }
    }

    @Override
    public MultiGetResponse multiGet(AuthHeader auth, MultiGetRequest request) {
        try {
            return this.internalClient.multiGet(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("multiGet failed", ioe);
        }
    }

    @Override
    public SearchResponse search(AuthHeader auth, SearchRequest request) {
        try {
            return this.internalClient.search(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("search failed", ioe);
        }
    }

    @Override
    public SearchResponse searchScroll(AuthHeader auth, SearchScrollRequest request) {
        try {
            return this.internalClient.searchScroll(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("searchScroll failed", ioe);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(AuthHeader auth, ClearScrollRequest request) {
        try {
            return this.internalClient.clearScroll(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("clearScroll failed", ioe);
        }
    }

    @Override
    public MultiSearchResponse multiSearch(AuthHeader auth, MultiSearchRequest request) {
        try {
            return this.internalClient.multiSearch(request, this.headers(auth));
        }
        catch (IOException ioe) {
            throw ElasticException.throwEx("multiSearch failed", ioe);
        }
    }

    @Override
    public MapResult xpackPut(AuthHeader auth, XPackApi api, String id, String body) {
        String putNotFound = this.simplePut(auth, api.type, api.endpointWith(id), body, api.name().toLowerCase() + "Put");
        return putNotFound == null ? MapResult.immutableResult() : BaseSerializer.deserialize((String)putNotFound);
    }

    @Override
    public MapResult xpackGet(AuthHeader auth, XPackApi api, String id) {
        String getNotFound = this.simpleGet(auth, api.endpointWith(id), api.name().toLowerCase() + "Get");
        return getNotFound == null ? MapResult.immutableResult() : BaseSerializer.deserialize((String)getNotFound);
    }

    @Override
    public void xpackDelete(AuthHeader auth, XPackApi api, String id) {
        this.simpleDelete(auth, api.endpointWith(id), api.name().toLowerCase() + "Delete");
    }

    @Override
    public void xpackDelete(AuthHeader auth, XPackApi api, String id, String body) {
        try {
            this.performCliRequest(HttpRequestBuilder.HttpReqType.DELETE, api.endpointWith(id), Collections.emptyMap(), (HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON), this.headers(auth));
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx(api.name().toLowerCase() + "Delete failed", ioe);
        }
    }

    private String simpleGet(AuthHeader auth, String endpoint, String methodName) {
        Throwable throwable;
        try {
            return this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.GET, endpoint);
        }
        catch (ResponseException re) {
            if (re.getResponse().getStatusLine().getStatusCode() == 404) {
                return null;
            }
            throwable = re;
        }
        catch (Exception ioe) {
            throwable = ioe;
        }
        throw ElasticException.throwEx(methodName + " failed", throwable);
    }

    private String simplePut(AuthHeader auth, HttpRequestBuilder.HttpReqType reqType, String endpoint, String body, String methodName) {
        try {
            return this.performCliRequest(reqType, endpoint, Collections.emptyMap(), (HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON), this.headers(auth));
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx(methodName + " failed", ioe);
        }
    }

    private void simpleDelete(AuthHeader auth, String endpoint, String methodName) {
        try {
            this.performCliRequest(auth, HttpRequestBuilder.HttpReqType.DELETE, endpoint);
        }
        catch (Exception ioe) {
            throw ElasticException.throwEx(methodName + " failed", ioe);
        }
    }

    private String performCliRequest(AuthHeader auth, HttpRequestBuilder.HttpReqType method, String endpoint) throws IOException {
        return this.performCliRequest(method, endpoint, Collections.emptyMap(), null, this.headers(auth));
    }

    private String performCliRequest(HttpRequestBuilder.HttpReqType method, String endpoint, Map<String, String> params, HttpEntity entity, Header ... headers) throws IOException {
        Response response = this.internalClient.getLowLevelClient().performRequest(method.name(), endpoint, params, entity, headers);
        int statusCode = response.getStatusLine().getStatusCode();
        ElasticException.checkState(statusCode >= 200 && statusCode < 300, response.getStatusLine().getReasonPhrase());
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    private Header[] headers(AuthHeader authHeader) {
        return ((AuthHeader)NullUtil.nonNull((Object)authHeader, (Object)this.bootstrapAuth)).headers();
    }

    ElasticRestClient(RestHighLevelClient internalClient, @Nullable AuthHeader bootstrapAuth) {
        this.internalClient = internalClient;
        this.bootstrapAuth = bootstrapAuth;
    }

    @Override
    @Nullable
    public AuthHeader bootstrapAuth() {
        return this.bootstrapAuth;
    }
}

