/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.elastic.search.Expression;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.search.MatchQuery;

public enum ExprConverter {
    All{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            return QueryBuilders.matchAllQuery();
        }
    }
    ,
    Bool{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            BoolQueryBuilder result = QueryBuilders.boolQuery();
            for (QueryBuilder child : CollUtil.transform((Iterable)((Iterable)expr.argFor("must")), ExprConverter::buildFilter)) {
                if (child == null) continue;
                result.must(child);
            }
            for (QueryBuilder child : CollUtil.transform((Iterable)((Iterable)expr.argFor("filter")), ExprConverter::buildFilter)) {
                if (child == null) continue;
                result.filter(child);
            }
            for (QueryBuilder child : CollUtil.transform((Iterable)((Iterable)expr.argFor("should")), ExprConverter::buildFilter)) {
                if (child == null) continue;
                result.should(child);
            }
            for (QueryBuilder child : CollUtil.transform((Iterable)((Iterable)expr.argFor("must_not")), ExprConverter::buildFilter)) {
                if (child == null) continue;
                result.mustNot(child);
            }
            return result;
        }
    }
    ,
    Eq{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            return QueryBuilders.termQuery((String)expr.label, expr.valueArg());
        }
    }
    ,
    Ne{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)expr.label, expr.valueArg()));
        }
    }
    ,
    In{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            return QueryBuilders.termsQuery((String)expr.label, expr.arrayArg());
        }
    }
    ,
    Text{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            String field = StrUtil.nullOrEmpty((String)expr.label) ? "&all" : expr.label;
            Operator operator = expr.args.containsKey((Object)"operator") ? Operator.valueOf((String)expr.stringArg("operator")) : Operator.AND;
            MatchQuery.Type type = MatchQuery.Type.valueOf((String)((String)NullUtil.nonNull((Object)expr.stringArg("type"), (Object)"PHRASE_PREFIX")));
            switch (type) {
                case BOOLEAN: {
                    return QueryBuilders.matchQuery((String)field, expr.valueArg()).operator(operator).analyzer(expr.stringArg("analyzer"));
                }
                case PHRASE: {
                    return QueryBuilders.matchPhraseQuery((String)field, expr.valueArg()).analyzer(expr.stringArg("analyzer"));
                }
            }
            return QueryBuilders.matchPhrasePrefixQuery((String)field, expr.valueArg()).analyzer(expr.stringArg("analyzer"));
        }
    }
    ,
    Exists{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            return QueryBuilders.existsQuery((String)expr.label);
        }
    }
    ,
    Missing{

        @Override
        QueryBuilder buildFrom(Expression expr) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)expr.label));
        }
    };


    abstract QueryBuilder buildFrom(Expression var1);

    public static QueryBuilder buildFilter(Expression expr) {
        return expr == null || Expression.NilExpression.equals(expr) ? null : ExprConverter.valueOf(expr.operation).buildFrom(expr);
    }

    private static QueryBuilder[] aggregateFilters(Collection<Expression> expressions) {
        return (QueryBuilder[])CollUtil.transform(expressions, ExprConverter::buildFilter).filter(Objects::nonNull).toArray(QueryBuilder.class);
    }

    public static String filterAsStr(Expression expr) {
        XContentBuilder result = XContentFactory.jsonBuilder();
        ExprConverter.buildFilter(expr).toXContent(result, ToXContent.EMPTY_PARAMS);
        return result.string();
    }
}

