/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.TokenUtil;
import io.polyglotted.elastic.client.XPackApi;
import java.io.Closeable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.xcontent.XContentType;

public interface ElasticClient
extends Closeable {
    @Override
    public void close();

    public AuthHeader bootstrapAuth();

    default public ElasticClient waitForYellow() {
        return this.waitForStatus("yellow");
    }

    default public ElasticClient waitForStatus(String status) {
        return this.waitForStatus(this.bootstrapAuth(), status);
    }

    public ElasticClient waitForStatus(AuthHeader var1, String var2);

    default public MapResult clusterHealth() {
        return this.clusterHealth(this.bootstrapAuth());
    }

    public MapResult clusterHealth(AuthHeader var1);

    default public boolean indexExists(String repo) {
        return this.indexExists(this.bootstrapAuth(), repo);
    }

    public boolean indexExists(AuthHeader var1, String var2);

    default public MapResult indexNameFor(String alias) {
        return this.indexNameFor(this.bootstrapAuth(), alias);
    }

    public MapResult indexNameFor(AuthHeader var1, String var2);

    default public String createIndex(String indexFile) {
        return this.createIndex(TokenUtil.uniqueToken(), indexFile);
    }

    default public String createIndex(String indexName, String indexFile) {
        return this.createIndex(this.bootstrapAuth(), indexName, indexFile);
    }

    default public String createIndex(AuthHeader auth, String indexName, String indexFile) {
        return this.createIndex(auth, new CreateIndexRequest(indexName).source(indexFile, XContentType.JSON));
    }

    default public String createIndex(CreateIndexRequest request) {
        return this.createIndex(this.bootstrapAuth(), request);
    }

    public String createIndex(AuthHeader var1, CreateIndexRequest var2);

    default public void dropIndex(String index) {
        this.dropIndex(this.bootstrapAuth(), index);
    }

    public void dropIndex(AuthHeader var1, String var2);

    default public void forceRefresh(String repo) {
        this.forceRefresh(this.bootstrapAuth(), repo);
    }

    public void forceRefresh(AuthHeader var1, String var2);

    default public String getSettings(String repo) {
        return this.getSettings(this.bootstrapAuth(), repo);
    }

    public String getSettings(AuthHeader var1, String var2);

    default public MapResult.ImmutableResult getMapping(String repo) {
        return this.getMapping(this.bootstrapAuth(), repo);
    }

    public MapResult.ImmutableResult getMapping(AuthHeader var1, String var2);

    default public void putPipeline(String id, String resource) {
        this.putPipeline(this.bootstrapAuth(), id, resource);
    }

    public void putPipeline(AuthHeader var1, String var2, String var3);

    default public boolean pipelineExists(String id) {
        return this.pipelineExists(this.bootstrapAuth(), id);
    }

    public boolean pipelineExists(AuthHeader var1, String var2);

    default public void deletePipeline(String id) {
        this.deletePipeline(this.bootstrapAuth(), id);
    }

    public void deletePipeline(AuthHeader var1, String var2);

    default public void putTemplate(String name, String body) {
        this.putTemplate(this.bootstrapAuth(), name, body);
    }

    public void putTemplate(AuthHeader var1, String var2, String var3);

    default public boolean templateExists(String name) {
        return this.templateExists(this.bootstrapAuth(), name);
    }

    public boolean templateExists(AuthHeader var1, String var2);

    default public void deleteTemplate(String name) {
        this.deleteTemplate(this.bootstrapAuth(), name);
    }

    public void deleteTemplate(AuthHeader var1, String var2);

    default public IndexResponse index(IndexRequest request) {
        return this.index(this.bootstrapAuth(), request);
    }

    public IndexResponse index(AuthHeader var1, IndexRequest var2);

    default public DeleteResponse delete(DeleteRequest request) {
        return this.delete(this.bootstrapAuth(), request);
    }

    public DeleteResponse delete(AuthHeader var1, DeleteRequest var2);

    default public BulkResponse bulk(BulkRequest bulk) {
        return this.bulk(this.bootstrapAuth(), bulk);
    }

    public BulkResponse bulk(AuthHeader var1, BulkRequest var2);

    default public void bulkAsync(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        this.bulkAsync(this.bootstrapAuth(), bulkRequest, listener);
    }

    public void bulkAsync(AuthHeader var1, BulkRequest var2, ActionListener<BulkResponse> var3);

    default public boolean exists(GetRequest request) {
        return this.exists(this.bootstrapAuth(), request);
    }

    public boolean exists(AuthHeader var1, GetRequest var2);

    default public MultiGetResponse multiGet(MultiGetRequest request) {
        return this.multiGet(this.bootstrapAuth(), request);
    }

    public MultiGetResponse multiGet(AuthHeader var1, MultiGetRequest var2);

    default public SearchResponse search(SearchRequest request) {
        return this.search(this.bootstrapAuth(), request);
    }

    public SearchResponse search(AuthHeader var1, SearchRequest var2);

    default public SearchResponse searchScroll(SearchScrollRequest request) {
        return this.searchScroll(this.bootstrapAuth(), request);
    }

    public SearchResponse searchScroll(AuthHeader var1, SearchScrollRequest var2);

    default public ClearScrollResponse clearScroll(ClearScrollRequest request) {
        return this.clearScroll(this.bootstrapAuth(), request);
    }

    public ClearScrollResponse clearScroll(AuthHeader var1, ClearScrollRequest var2);

    default public MapResult xpackPut(XPackApi api, String id, String body) {
        return this.xpackPut(this.bootstrapAuth(), api, id, body);
    }

    public MapResult xpackPut(AuthHeader var1, XPackApi var2, String var3, String var4);

    default public MapResult xpackGet(XPackApi api, String id) {
        return this.xpackGet(this.bootstrapAuth(), api, id);
    }

    public MapResult xpackGet(AuthHeader var1, XPackApi var2, String var3);

    default public void xpackDelete(XPackApi api, String id) {
        this.xpackDelete(this.bootstrapAuth(), api, id);
    }

    public void xpackDelete(AuthHeader var1, XPackApi var2, String var3);

    default public void xpackDelete(XPackApi api, String id, String body) {
        this.xpackDelete(this.bootstrapAuth(), api, id, body);
    }

    public void xpackDelete(AuthHeader var1, XPackApi var2, String var3, String var4);
}

