/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import io.polyglotted.common.model.Jsoner;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.admin.Field;
import io.polyglotted.elastic.admin.TypeSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public final class Type
implements Jsoner {
    public final String type = "_doc";
    public final boolean strict;
    public final boolean enabled;
    public final boolean enableSource;
    public final boolean enableSize;
    public final boolean enableAll;
    public final boolean enableAutocomplete;
    public final boolean includeMeta;
    public final boolean hasApproval;
    public final Set<Field> fields;
    public final MapResult.ImmutableResult meta;
    public final Set<String> srcExcludes;
    public final Map<String, List<String>> relations;

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.toJson().equals(((Type)o).toJson());
    }

    public int hashCode() {
        return 29 * this.toJson().hashCode();
    }

    public boolean hasRelations() {
        return this.relations.size() > 0;
    }

    public String toJson() {
        return TypeSerializer.serializeType(this);
    }

    List<String> sourceExcludes() {
        return ListBuilder.immutableListBuilder().addAll(this.srcExcludes).addAll((Iterable)CollUtil.transformColl((Collection)CollUtil.filterColl(this.fields, Field::excludeFromSrc), Field::field)).build();
    }

    public static Builder typeBuilder() {
        return new Builder().exclude("&autoComplete");
    }

    public String toString() {
        return "Type(" + this.type + ", " + this.strict + ", " + this.enabled + ", " + this.enableSource + ", " + this.enableSize + ", " + this.enableAll + ", " + this.enableAutocomplete + ", " + this.includeMeta + ", " + this.hasApproval + ", " + this.fields + ", " + this.meta + ", " + this.srcExcludes + ", " + this.relations + ")";
    }

    private Type(boolean strict, boolean enabled, boolean enableSource, boolean enableSize, boolean enableAll, boolean enableAutocomplete, boolean includeMeta, boolean hasApproval, Set<Field> fields, MapResult.ImmutableResult meta, Set<String> srcExcludes, Map<String, List<String>> relations) {
        this.strict = strict;
        this.enabled = enabled;
        this.enableSource = enableSource;
        this.enableSize = enableSize;
        this.enableAll = enableAll;
        this.enableAutocomplete = enableAutocomplete;
        this.includeMeta = includeMeta;
        this.hasApproval = hasApproval;
        this.fields = fields;
        this.meta = meta;
        this.srcExcludes = srcExcludes;
        this.relations = relations;
    }

    public static class Builder {
        private boolean strict = false;
        private boolean enabled = true;
        private boolean enableSource = true;
        private boolean enableSize = true;
        private boolean enableAll = true;
        private boolean enableAutocomplete = true;
        private boolean includeMeta = true;
        private boolean hasApproval = false;
        private final Set<Field> fields = new TreeSet<Field>();
        private final MapBuilder.ImmutableMapBuilder<String, Object> metaData = MapResult.immutableResultBuilder();
        private final Set<String> srcExcludes = new TreeSet<String>();
        private final ListMultimap<String, String> relations = ArrayListMultimap.create();

        public Builder strict() {
            return this.strict(true);
        }

        public Builder field(Field.FieldBuilder builder) {
            return this.field(builder.build());
        }

        public Builder field(Field field) {
            return this.fields(Collections.singleton(field));
        }

        public Builder fields(Collection<Field> fields) {
            this.fields.removeAll(fields);
            this.fields.addAll(fields);
            return this;
        }

        public Builder exclude(String excl) {
            this.srcExcludes.add(excl);
            return this;
        }

        public Builder metaData(String name, Object value) {
            this.metaData.put((Object)name, value);
            return this;
        }

        public Builder relation(String parent, String child) {
            this.relations.put((Object)parent, (Object)child);
            return this;
        }

        public Builder relation(String parent, Iterable<String> children) {
            this.relations.putAll((Object)parent, children);
            return this;
        }

        public Builder with(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public Type build() {
            return new Type(this.strict, this.enabled, this.enableSource, this.enableSize, this.enableAll, this.enableAutocomplete, this.includeMeta, this.hasApproval, (Set)ListBuilder.immutableSet(this.fields), this.metaData.immutable(), (Set)ListBuilder.immutableSet(this.srcExcludes), (Map)MapBuilder.immutableMap((Map)Multimaps.asMap(this.relations)));
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enableSource(boolean enableSource) {
            this.enableSource = enableSource;
            return this;
        }

        public Builder enableSize(boolean enableSize) {
            this.enableSize = enableSize;
            return this;
        }

        public Builder enableAll(boolean enableAll) {
            this.enableAll = enableAll;
            return this;
        }

        public Builder enableAutocomplete(boolean enableAutocomplete) {
            this.enableAutocomplete = enableAutocomplete;
            return this;
        }

        public Builder includeMeta(boolean includeMeta) {
            this.includeMeta = includeMeta;
            return this;
        }

        public Builder hasApproval(boolean hasApproval) {
            this.hasApproval = hasApproval;
            return this;
        }

        private Builder() {
        }
    }
}

