/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.DocResult;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.index.BulkRecord;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.search.Expression;
import io.polyglotted.elastic.search.Expressions;
import io.polyglotted.elastic.search.QueryMaker;
import io.polyglotted.elastic.search.ResponseBuilder;
import io.polyglotted.elastic.search.SearchUtil;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Finder {
    private static final Logger log = LoggerFactory.getLogger(Finder.class);

    public static Map<String, DocResult> findAll(ElasticClient client, AuthHeader auth, BulkRecord record) {
        Expressions.BoolBuilder builder = Finder.idBuilder(record.model, record.parent, Expressions.in("&id", CollUtil.transform(record.records, IndexRecord::getId))).liveOrPending();
        return CollUtil.uniqueIndex(Finder.findAllBy(client, auth, record.repo, builder.build(), record.size(), FetchSourceContext.FETCH_SOURCE), DocResult::keyString);
    }

    public static List<DocResult> findAllBy(ElasticClient client, AuthHeader auth, String repo, Expression expr, int size, FetchSourceContext ctx) {
        SearchRequest searchRequest = QueryMaker.filterToRequest(repo, expr, ctx, ListBuilder.immutableList(), size);
        SearchResponse response = client.search(auth, searchRequest);
        return ResponseBuilder.DocResultBuilder.buildFrom(response, Verbose.NONE);
    }

    public static DocResult findByKey(ElasticClient client, AuthHeader auth, String repo, String key) {
        return Finder.findByKey(client, auth, repo, key, null);
    }

    public static DocResult findByKey(ElasticClient client, AuthHeader auth, String repo, String key, FetchSourceContext context) {
        return Finder.findBy(client, auth, repo, Expressions.equalsTo("&key", key), context);
    }

    public static DocResult findById(ElasticClient client, AuthHeader auth, String repo, String model, String id) {
        return Finder.findById(client, auth, repo, model, id, null, null);
    }

    public static DocResult findById(ElasticClient client, AuthHeader auth, String repo, String model, String id, String parent, FetchSourceContext ctx) {
        return Finder.findBy(client, auth, repo, Finder.idBuilder(model, parent, Expressions.equalsTo("&id", id)).liveOrPending().build(), ctx);
    }

    public static DocResult findBy(ElasticClient client, AuthHeader auth, String repo, Expression expr, FetchSourceContext context) {
        SearchRequest searchRequest = QueryMaker.filterToRequest(repo, expr, context, ListBuilder.immutableList(), 1);
        SearchResponse response = client.search(auth, searchRequest);
        return SearchUtil.getReturnedHits(response) > 0 ? ResponseBuilder.DocResultBuilder.buildFrom(response, Verbose.NONE).get(0) : null;
    }

    public static Expressions.BoolBuilder idBuilder(String model, Expression ... musts) {
        return Finder.idBuilder(model, null, musts);
    }

    public static Expressions.BoolBuilder idBuilder(String model, String parent, Expression ... musts) {
        Expressions.BoolBuilder idBuilder = Expressions.bool().must(Expressions.equalsTo("&model", model)).musts(musts);
        if (parent != null) {
            idBuilder.filter(Expressions.equalsTo("&parent", parent));
        }
        return idBuilder;
    }
}

