/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import com.google.common.collect.ImmutableList;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.common.DocStatus;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.common.Notification;
import io.polyglotted.elastic.index.ApprovalUtil;
import io.polyglotted.elastic.index.IgnoreErrors;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public final class BulkRecord {
    public final String repo;
    public final String model;
    public final String parent;
    public final List<IndexRecord> records;
    public final IgnoreErrors ignoreErrors;
    public final Validator validator;
    private final Notification.Builder notification;
    public final Map<String, String> failures = MapBuilder.simpleMap();

    public Notification notification() {
        return this.notification.build();
    }

    public int size() {
        return this.records.size();
    }

    void success(int index, String result) {
        if (this.notification != null) {
            this.successWith(this.notification.idOf(index), result);
        }
    }

    void successWith(String id, String result) {
        if (this.notification != null) {
            this.notification.keyAction(id, result);
        }
    }

    void failure(int index, String result) {
        this.failureWith(this.notification != null ? this.notification.idOf(index) : String.valueOf(index), result);
    }

    void failureWith(String id, String result) {
        this.failures.put(id, result);
    }

    public static Builder bulkBuilder(String repo, String model, long timestamp, String user) {
        return new Builder(Objects.requireNonNull(repo), Objects.requireNonNull(model), timestamp, Objects.requireNonNull(user));
    }

    private static boolean isChangeAction(String action) {
        return "created".equals(action) || "updated".equals(action) || "deleted".equals(action);
    }

    private BulkRecord(String repo, String model, String parent, List<IndexRecord> records, IgnoreErrors ignoreErrors, Validator validator, Notification.Builder notification) {
        this.repo = repo;
        this.model = model;
        this.parent = parent;
        this.records = records;
        this.ignoreErrors = ignoreErrors;
        this.validator = validator;
        this.notification = notification;
    }

    public static class Builder {
        @NonNull
        private final String repo;
        @NonNull
        private final String model;
        private final long timestamp;
        @NonNull
        private final String user;
        private String parent;
        private boolean hasApproval;
        @NonNull
        private IgnoreErrors ignoreErrors = IgnoreErrors.STRICT;
        @NonNull
        private Validator validator = Validator.STRICT;
        private Notification.Builder notification;
        private final ListBuilder.ImmutableListBuilder<IndexRecord> records = ListBuilder.immutableListBuilder();

        public Builder withNotification() {
            return this.notification(Notification.notificationBuilder());
        }

        public Builder withNotification(String realm) {
            return this.notification(Notification.notificationBuilder().realm(realm));
        }

        public Builder hasApproval() {
            return this.hasApproval(true);
        }

        public Builder record(IndexRecord record) {
            this.records.add((Object)this.checkParent(record));
            return this;
        }

        public Builder records(Iterable<IndexRecord> records) {
            for (IndexRecord rec : records) {
                this.record(rec);
            }
            return this;
        }

        public Builder objects(Iterable<MapResult> docs) {
            for (MapResult doc : docs) {
                this.record(this.indexRec(doc).build());
            }
            return this;
        }

        public Builder objectsWith(Iterable<MapResult> docs, String pipeline) {
            for (MapResult doc : docs) {
                this.record(this.indexRec(doc).pipeline(pipeline).build());
            }
            return this;
        }

        private IndexRecord.Builder indexRec(MapResult doc) {
            IndexRecord.Builder builder = this.hasApproval ? IndexRecord.createRecord(this.repo, ApprovalUtil.approvalModel(this.model), MetaFields.id(doc), MetaFields.parent(doc), doc).status(DocStatus.PENDING) : IndexRecord.saveRecord(this.repo, this.model, MetaFields.id(doc), MetaFields.parent(doc), MetaFields.tstamp(doc), doc);
            return builder.userTs(this.user, this.timestamp);
        }

        private IndexRecord checkParent(IndexRecord record) {
            Assertions.checkBool((boolean)Objects.equals(this.parent, record.parent), (String)"bulk record cannot index child records for multiple parents");
            return record;
        }

        public BulkRecord build() {
            ImmutableList recordsList = this.records.build();
            if (this.notification != null) {
                recordsList.forEach(record -> this.notification.key(record.id, record.simpleKey()));
            }
            return new BulkRecord(this.repo, this.model, this.parent, (List)recordsList, this.ignoreErrors, this.validator, this.notification);
        }

        public Builder(@NonNull String repo, @NonNull String model, long timestamp, @NonNull String user) {
            if (repo == null) {
                throw new NullPointerException("repo");
            }
            if (model == null) {
                throw new NullPointerException("model");
            }
            if (user == null) {
                throw new NullPointerException("user");
            }
            this.repo = repo;
            this.model = model;
            this.timestamp = timestamp;
            this.user = user;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder hasApproval(boolean hasApproval) {
            this.hasApproval = hasApproval;
            return this;
        }

        public Builder ignoreErrors(@NonNull IgnoreErrors ignoreErrors) {
            if (ignoreErrors == null) {
                throw new NullPointerException("ignoreErrors");
            }
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public Builder validator(@NonNull Validator validator) {
            if (validator == null) {
                throw new NullPointerException("validator");
            }
            this.validator = validator;
            return this;
        }

        public Builder notification(Notification.Builder notification) {
            this.notification = notification;
            return this;
        }
    }
}

