/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.elastic.common.MetaFields;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public enum Verbose {
    NONE((List)ListBuilder.immutableList()){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return result;
        }
    }
    ,
    ID((List)ListBuilder.immutableList((Object[])new String[]{"&id"})){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return (T)Verbose.addHeader(result, (MapResult)MapResult.immutableResult((String)"&id", (Object)MetaFields.reqdId(source)));
        }
    }
    ,
    KEY((List)ListBuilder.immutableList((Object[])new String[]{"&key"})){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return (T)Verbose.addHeader(result, (MapResult)MapResult.immutableResult((String)"&key", (Object)MetaFields.reqdKey(source)));
        }
    }
    ,
    MINIMAL((List)ListBuilder.immutableList((Object[])new String[]{"&link", "&model", "&parent", "&id", "&timestamp", "&key"})){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return (T)Verbose.addHeader(result, MetaFields.readKey(source).result());
        }
    }
    ,
    PARENT((List)ListBuilder.immutableList((Object[])new String[]{"&parent"})){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return (T)Verbose.addHeader(result, (MapResult)MapResult.immutableResult((String)"&parent", (Object)MetaFields.parent(source)));
        }
    }
    ,
    UNIQUE((List)ListBuilder.immutableList((Object[])new String[]{"&id", "&key"})){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return (T)Verbose.addHeader(result, (MapResult)MapResult.immutableResult((String)"&id", (Object)MetaFields.reqdId(source), (String)"&key", (Object)MetaFields.reqdKey(source)));
        }
    }
    ,
    META(MetaFields.ALL_FIELDS.toArray(new String[MetaFields.ALL_FIELDS.size()]), new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY)){

        @Override
        public <T> T buildFrom(MapResult source, T result) {
            return (T)Verbose.addHeader(result, MetaFields.readHeader(source));
        }
    };

    public final String[] fields;
    public final FetchSourceContext fetchContext;

    private Verbose(List<String> fields) {
        this(fields.toArray(new String[0]), new FetchSourceContext(true, Strings.EMPTY_ARRAY, Verbose.excludeFromAll(fields)));
    }

    public abstract <T> T buildFrom(MapResult var1, T var2);

    public String[] includeFields(String[] includeFields) {
        if (includeFields.length <= 0) {
            return includeFields;
        }
        String[] result = new String[this.fields.length + includeFields.length];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        System.arraycopy(includeFields, 0, result, this.fields.length, includeFields.length);
        return result;
    }

    public static String param(Verbose verbose) {
        return verbose == null || verbose == NONE ? null : verbose.toString();
    }

    public static Verbose toMeta(String verb) {
        return verb == null ? NONE : META;
    }

    public static Verbose fromVerb(String verb) {
        return verb == null ? NONE : (verb.isEmpty() ? META : Verbose.valueOf(verb.toUpperCase()));
    }

    private static <T> T addHeader(T result, MapResult header) {
        if (result instanceof MapResult) {
            ((MapResult)result).putAll((Map)header);
        } else {
            Object meta = ReflectionUtil.fieldValue(result, (String)"_meta");
            if (meta instanceof MapResult) {
                ((MapResult)meta).putAll((Map)header);
            }
        }
        return result;
    }

    private static String[] excludeFromAll(List<String> fields) {
        List excludes = ListBuilder.simpleList(MetaFields.ALL_FIELDS);
        excludes.removeAll(fields);
        return excludes.toArray(new String[0]);
    }

    private Verbose(String[] fields, FetchSourceContext fetchContext) {
        this.fields = fields;
        this.fetchContext = fetchContext;
    }
}

