/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import com.google.common.collect.Iterables;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.StrUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Notification {
    public final String realm;
    public final List<KeyAction> keyActions;

    public static Notification notification(String realm, String id, String key, String singleResult) {
        return new Notification(realm, (List<KeyAction>)ListBuilder.immutableList((Object[])new KeyAction[]{new KeyAction(id, key, StrUtil.safePrefix((String)StrUtil.safeSuffix((String)singleResult, (String)"&result\":\""), (String)"\""))}));
    }

    public static Builder notificationBuilder() {
        return new Builder();
    }

    public Notification(String realm, List<KeyAction> keyActions) {
        this.realm = realm;
        this.keyActions = keyActions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$realm = this.realm;
        String other$realm = other.realm;
        if (this$realm == null ? other$realm != null : !this$realm.equals(other$realm)) {
            return false;
        }
        List<KeyAction> this$keyActions = this.keyActions;
        List<KeyAction> other$keyActions = other.keyActions;
        return !(this$keyActions == null ? other$keyActions != null : !((Object)this$keyActions).equals(other$keyActions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Notification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realm = this.realm;
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        List<KeyAction> $keyActions = this.keyActions;
        result = result * 59 + ($keyActions == null ? 43 : ((Object)$keyActions).hashCode());
        return result;
    }

    public static class Builder {
        private String realm;
        private final Map<String, String> idKeys = new LinkedHashMap<String, String>();
        private final List<KeyAction> keyActions = new LinkedList<KeyAction>();

        public String idOf(int index) {
            return (String)Iterables.get(this.idKeys.keySet(), (int)index);
        }

        public Builder key(String id, String key) {
            this.idKeys.put(id, key);
            return this;
        }

        public Builder keyAction(String id, String action) {
            if (id != null) {
                this.keyActions.add(new KeyAction(id, this.idKeys.get(id), action));
            }
            return this;
        }

        public Notification build() {
            return new Notification(this.realm, (List<KeyAction>)ListBuilder.immutableList(this.keyActions));
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        private Builder() {
        }
    }

    public static class KeyAction {
        public final String id;
        public final String key;
        public final String action;

        KeyAction() {
            this(null, null, null);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyAction)) {
                return false;
            }
            KeyAction other = (KeyAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id;
            String other$id = other.id;
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$key = this.key();
            String other$key = other.key();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$action = this.action;
            String other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }

        public KeyAction(String id, String key, String action) {
            this.id = id;
            this.key = key;
            this.action = action;
        }

        public String key() {
            return this.key;
        }
    }
}

