/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.elastic.client.ElasticSettings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalHostsSniffer
implements HostsSniffer {
    private static final Logger log = LoggerFactory.getLogger(InternalHostsSniffer.class);
    private final RestClient lowLevelClient;
    private final ElasticSettings settings;
    private final AuthHeader bootstrapAuth;

    static Sniffer buildSniffer(RestClient lowLevelClient, ElasticSettings settings, AuthHeader authHeader) {
        return Sniffer.builder((RestClient)lowLevelClient).setHostsSniffer((HostsSniffer)new InternalHostsSniffer(lowLevelClient, settings, authHeader)).build();
    }

    public List<HttpHost> sniffHosts() {
        MapResult result = BaseSerializer.deserialize((String)this.performCliRequest());
        ListBuilder.SimpleListBuilder addresses = ListBuilder.simpleListBuilder();
        for (Map.Entry entry : result.mapVal("nodes").entrySet()) {
            addresses.add((Object)((String)((Map)MapRetriever.MAP_CLASS.cast(entry.getValue())).get("ip")));
        }
        return CollUtil.transformList((List)addresses.build(), node -> new HttpHost(Objects.requireNonNull(node), this.settings.getPort(), this.settings.getScheme()));
    }

    private String performCliRequest() {
        try {
            Response response = this.lowLevelClient.performRequest("GET", "/_nodes/http", Collections.emptyMap(), null, this.bootstrapAuth.headers());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            log.warn("sniff failed: " + response.getStatusLine().getReasonPhrase());
        }
        catch (Exception ex) {
            log.error("sniff error", (Throwable)ex);
        }
        return "{}";
    }

    public InternalHostsSniffer(RestClient lowLevelClient, ElasticSettings settings, AuthHeader bootstrapAuth) {
        this.lowLevelClient = lowLevelClient;
        this.settings = settings;
        this.bootstrapAuth = bootstrapAuth;
    }
}

