/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.CommaUtil;
import io.polyglotted.common.util.InsecureSslFactory;
import io.polyglotted.common.util.ResourceUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.ElasticRestClient;
import io.polyglotted.elastic.client.ElasticSettings;
import java.security.KeyStore;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighLevelConnector {
    private static final Logger log = LoggerFactory.getLogger(HighLevelConnector.class);

    public static ElasticClient highLevelClient(ElasticSettings settings) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])HighLevelConnector.buildHosts(settings)).setMaxRetryTimeoutMillis(settings.retryTimeoutMillis).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(settings.connectTimeoutMillis).setSocketTimeout(settings.socketTimeoutMillis)).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSSLContext(settings.insecure ? InsecureSslFactory.insecureSslContext((String)settings.host, (int)settings.port) : HighLevelConnector.predeterminedContext()));
        return new ElasticRestClient(restClientBuilder, settings, settings.bootstrapAuth());
    }

    private static SSLContext predeterminedContext() {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(ResourceUtil.urlStream(HighLevelConnector.class, (String)"elastic-stack-ca.p12"), new char[0]);
        return SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
    }

    private static HttpHost[] buildHosts(ElasticSettings settings) {
        List hosts = CommaUtil.commaSplit((String)settings.host);
        log.info("received default hosts: " + hosts);
        return (HttpHost[])CollUtil.transform((Iterable)hosts, node -> new HttpHost(Objects.requireNonNull(node), settings.port, settings.scheme)).toArray(HttpHost.class);
    }
}

