/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.DocResult;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.search.Expression;
import io.polyglotted.elastic.search.Finder;
import io.polyglotted.elastic.search.QueryMaker;
import io.polyglotted.elastic.search.QueryResponse;
import io.polyglotted.elastic.search.ResponseBuilder;
import io.polyglotted.elastic.search.ResultBuilder;
import io.polyglotted.elastic.search.ScrollWalker;
import io.polyglotted.elastic.search.SearchUtil;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Searcher {
    private static final Logger log = LoggerFactory.getLogger(Searcher.class);
    private final ElasticClient client;

    public <T> List<T> getAllBy(String repo, String model, Expression expr, int size, FetchSourceContext context, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return this.getAllBy(null, repo, model, expr, size, context, resultBuilder, verbose);
    }

    public <T> List<T> getAllBy(AuthHeader auth, String repo, String model, Expression expr, int size, FetchSourceContext context, ResultBuilder<T> builder, Verbose verbose) {
        return CollUtil.transformList(Finder.findAllBy(this.client, auth, repo, expr, size, context), docResult -> builder.buildVerbose(DocResult.docSource(docResult), verbose));
    }

    public <T> T getById(String repo, String model, String id, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return this.getById(null, repo, model, id, null, FetchSourceContext.FETCH_SOURCE, resultBuilder, verbose);
    }

    public <T> T getById(AuthHeader auth, String repo, String model, String id, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return this.getById(auth, repo, model, id, null, FetchSourceContext.FETCH_SOURCE, resultBuilder, verbose);
    }

    public <T> T getById(String repo, String model, String id, String parent, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return this.getById(null, repo, model, id, parent, resultBuilder, verbose);
    }

    public <T> T getById(AuthHeader auth, String repo, String model, String id, String parent, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return this.getById(auth, repo, model, id, parent, FetchSourceContext.FETCH_SOURCE, resultBuilder, verbose);
    }

    public <T> T getById(String repo, String model, String id, String parent, FetchSourceContext ctx, ResultBuilder<T> builder, Verbose verbose) {
        return this.getById(null, repo, model, id, parent, ctx, builder, verbose);
    }

    public <T> T getById(AuthHeader auth, String repo, String model, String id, String parent, FetchSourceContext ctx, ResultBuilder<T> builder, Verbose verbose) {
        return builder.buildVerbose(DocResult.docSource(Finder.findById(this.client, auth, repo, model, id, parent, ctx)), verbose);
    }

    public <T> T getByExpr(String repo, Expression expr, FetchSourceContext ctx, ResultBuilder<T> builder, Verbose verbose) {
        return this.getByExpr(null, repo, expr, ctx, builder, verbose);
    }

    public <T> T getByExpr(AuthHeader auth, String repo, Expression expr, FetchSourceContext ctx, ResultBuilder<T> builder, Verbose verbose) {
        return builder.buildVerbose(DocResult.docSource(Finder.findBy(this.client, auth, repo, expr, ctx)), verbose);
    }

    public <T> QueryResponse searchBy(SearchRequest request, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        return this.searchBy(null, request, resultBuilder, verbose);
    }

    public <T> QueryResponse searchBy(AuthHeader auth, SearchRequest request, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        return SearchUtil.responseBuilder(auth == null ? this.client.search(request) : this.client.search(auth, request), resultBuilder, verbose).build();
    }

    public <T> QueryResponse scroll(String scrollId, TimeValue scrollTime, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        return this.scroll(null, scrollId, scrollTime, resultBuilder, verbose);
    }

    public <T> QueryResponse scroll(AuthHeader auth, String scrollId, TimeValue scrollTime, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        SearchScrollRequest request = QueryMaker.scrollRequest(scrollId, scrollTime);
        return SearchUtil.responseBuilder(auth == null ? this.client.searchScroll(request) : this.client.searchScroll(auth, request), resultBuilder, verbose).build();
    }

    public <T> String searchNative(SearchRequest request, ResponseBuilder<T> resultBuilder, boolean flattenAgg, Verbose verbose) {
        return this.searchNative(null, request, resultBuilder, flattenAgg, verbose);
    }

    public <T> String searchNative(AuthHeader auth, SearchRequest request, ResponseBuilder<T> resultBuilder, boolean flattenAgg, Verbose verbose) {
        XContentBuilder result = XContentFactory.jsonBuilder().startObject();
        SearchResponse response = auth == null ? this.client.search(request) : this.client.search(auth, request);
        SearchUtil.headerFrom(response, result);
        if (SearchUtil.getReturnedHits(response) > 0) {
            List<T> values = resultBuilder.buildFrom(response, verbose);
            result.rawField("results", (BytesReference)new BytesArray(BaseSerializer.MAPPER.writeValueAsBytes(values)), XContentType.JSON);
        }
        return SearchUtil.buildAggs(response, flattenAgg, result).endObject().string();
    }

    public <T> boolean simpleScroll(SearchRequest request, ResponseBuilder<T> resultBuilder, Verbose verbose, ScrollWalker<T> walker) {
        return this.simpleScroll(null, request, resultBuilder, verbose, walker);
    }

    public <T> boolean simpleScroll(AuthHeader auth, SearchRequest request, ResponseBuilder<T> resultBuilder, Verbose verbose, ScrollWalker<T> walker) {
        boolean errored = false;
        SearchResponse response = auth == null ? this.client.search(request) : this.client.search(auth, request);
        log.info("performing scroll on " + SearchUtil.getTotalHits(response) + " items");
        while (SearchUtil.getReturnedHits(response) > 0) {
            errored = walker.walk(resultBuilder.buildFrom(response, verbose));
            if (errored) {
                SearchUtil.clearScroll(this.client, auth, response);
                break;
            }
            response = SearchUtil.performScroll(this.client, auth, response);
        }
        return errored;
    }

    public Searcher(ElasticClient client) {
        this.client = client;
    }
}

