/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.search.Aggregation;
import io.polyglotted.elastic.search.AggsConverter;
import io.polyglotted.elastic.search.AggsFlattener;
import io.polyglotted.elastic.search.QueryMaker;
import io.polyglotted.elastic.search.QueryResponse;
import io.polyglotted.elastic.search.ResponseBuilder;
import io.polyglotted.elastic.search.ResponseHeader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregations;

abstract class SearchUtil {
    SearchUtil() {
    }

    static <T> QueryResponse.Builder responseBuilder(SearchResponse searchResponse, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        QueryResponse.Builder responseBuilder = QueryResponse.responseBuilder();
        responseBuilder.header(SearchUtil.headerFrom(searchResponse));
        if (SearchUtil.getReturnedHits(searchResponse) > 0) {
            responseBuilder.results(resultBuilder.buildFrom(searchResponse, verbose));
        }
        return responseBuilder;
    }

    static SearchResponse performScroll(ElasticClient client, AuthHeader auth, SearchResponse response) {
        SearchScrollRequest scrollRequest = new SearchScrollRequest(response.getScrollId()).scroll(QueryMaker.DEFAULT_KEEP_ALIVE);
        return client.searchScroll(auth, scrollRequest);
    }

    static void clearScroll(ElasticClient client, AuthHeader auth, SearchResponse response) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(response.getScrollId());
        client.clearScroll(auth, clearScrollRequest);
    }

    static ResponseHeader headerFrom(SearchResponse response) {
        return new ResponseHeader(response.getTook().millis(), SearchUtil.getTotalHits(response), SearchUtil.getReturnedHits(response), response.getScrollId());
    }

    static void headerFrom(SearchResponse response, XContentBuilder builder) throws IOException {
        builder.startObject("header").field("tookInMillis", response.getTook().millis()).field("totalHits", SearchUtil.getTotalHits(response)).field("returnedHits", SearchUtil.getReturnedHits(response)).field("scrollId", response.getScrollId()).endObject();
    }

    static int getReturnedHits(SearchResponse response) {
        return response.getHits().getHits().length;
    }

    static long getTotalHits(SearchResponse response) {
        return response.getHits().getTotalHits();
    }

    static MapResult hitSource(SearchHit hit) {
        return Objects.requireNonNull(hit).hasSource() ? MapResult.simpleResult((Map)hit.getSourceAsMap()) : MapResult.simpleResult();
    }

    static XContentBuilder buildAggs(SearchResponse response, boolean flattenAgg, XContentBuilder result) throws IOException {
        Aggregations aggregations = response.getAggregations();
        if (aggregations != null) {
            return flattenAgg ? SearchUtil.performFlatten(result, aggregations) : SearchUtil.performInternal(result, aggregations);
        }
        return result;
    }

    private static XContentBuilder performFlatten(XContentBuilder result, Aggregations aggregations) throws IOException {
        result.startObject("flattened");
        for (org.elasticsearch.search.aggregations.Aggregation agg : aggregations) {
            Aggregation aggregation = AggsConverter.detectAgg(agg).build();
            Iterator<List<Object>> flattened = AggsFlattener.flattenAggs(aggregation);
            result.startArray(aggregation.label);
            while (flattened.hasNext()) {
                result.value(flattened.next());
            }
            result.endArray();
        }
        return result.endObject();
    }

    private static XContentBuilder performInternal(XContentBuilder result, Aggregations aggregations) throws IOException {
        aggregations.toXContent(result, ToXContent.EMPTY_PARAMS);
        return result;
    }
}

