/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.DocResult;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.index.BulkRecord;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.IndexerException;
import io.polyglotted.elastic.index.NoopException;
import io.polyglotted.elastic.index.RecordAction;
import io.polyglotted.elastic.search.Finder;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Validator {
    public static final Validator STRICT = new StrictValidator();
    public static final Validator OVERRIDE = new OverwriteValidator();

    public BulkRequest validateAll(ElasticClient var1, AuthHeader var2, BulkRecord var3, BulkRequest var4);

    public IndexRequest validate(ElasticClient var1, AuthHeader var2, IndexRecord var3);

    public static boolean isIdempotent(IndexRecord record, DocResult existing) {
        if (existing == null || record.action.notCreateOrUpdate() || !(record.source instanceof Map)) {
            return false;
        }
        Map<String, Object> current = DocResult.filtered((MapResult)record.source);
        return current.equals(DocResult.filtered(existing.source));
    }

    public static class OverwriteValidator
    implements Validator {
        private static final Logger log = LoggerFactory.getLogger(OverwriteValidator.class);

        @Override
        public BulkRequest validateAll(ElasticClient client, AuthHeader auth, BulkRecord bulkRecord, BulkRequest bulkRequest) {
            Map<String, DocResult> docs = Finder.findAll(client, auth, bulkRecord);
            for (IndexRecord record : bulkRecord.records) {
                try {
                    IndexRequest ancestor = this.checkRecordWithDoc(record, docs.get(record.keyString()));
                    bulkRequest.add(record.request());
                    if (ancestor == null) continue;
                    bulkRequest.add(ancestor);
                }
                catch (NoopException nex) {
                    bulkRecord.success(record.id, nex.getMessage());
                }
                catch (Exception ex) {
                    bulkRecord.failure(record.id, ex.getMessage());
                }
            }
            return bulkRequest;
        }

        @Override
        public final IndexRequest validate(ElasticClient client, AuthHeader auth, IndexRecord record) {
            this.preValidate(client, record);
            DocResult existing = Finder.findById(client, auth, record.repo, record.model, record.id, record.parent, FetchSourceContext.FETCH_SOURCE);
            return this.checkRecordWithDoc(record, existing);
        }

        private IndexRequest checkRecordWithDoc(IndexRecord record, DocResult existing) {
            if (Validator.isIdempotent(record, existing)) {
                throw new NoopException(existing.source);
            }
            this.validateCurrent(record, existing == null ? null : existing.source);
            this.postValidate(record);
            return existing == null ? null : OverwriteValidator.createParentRequest(record, existing);
        }

        protected void preValidate(ElasticClient client, IndexRecord record) {
        }

        protected void postValidate(IndexRecord record) {
        }

        protected void validateCurrent(IndexRecord record, MapResult current) {
        }

        public static IndexRequest createParentRequest(IndexRecord record, DocResult ancestor) {
            record.update(ancestor.id, MetaFields.reqdKey(ancestor.source), record.action.status);
            if (log.isTraceEnabled()) {
                log.trace("creating archive record for " + record.simpleKey());
            }
            return ancestor.ancestorRequest(record.repo, (MapResult)record.ancillary, record.parent, record.action.status);
        }
    }

    public static class StrictValidator
    extends OverwriteValidator {
        private static final Logger log = LoggerFactory.getLogger(StrictValidator.class);

        @Override
        protected void validateCurrent(IndexRecord record, MapResult current) {
            String keyString = record.keyString();
            if (record.action != RecordAction.CREATE) {
                if (current == null) {
                    throw new IndexerException(keyString + " - record not found for update");
                }
                if (record.baseVersion == null) {
                    throw new IndexerException(keyString + " - baseVersion not found for update");
                }
                if (MetaFields.timestamp(current) != record.baseVersion) {
                    throw new IndexerException(keyString + " - version conflict for update");
                }
            } else if (current != null) {
                throw new IndexerException(keyString + " - record already exists");
            }
        }
    }
}

