/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.AuthHeader;
import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.index.BulkRecord;
import io.polyglotted.elastic.index.IgnoreErrors;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.IndexerException;
import io.polyglotted.elastic.index.NoopException;
import io.polyglotted.elastic.index.Validator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Indexer {
    private static final Logger log = LoggerFactory.getLogger(Indexer.class);
    private final ElasticClient client;

    public void lockTheIndexOrFail(String repo, String keyString) {
        this.lockTheIndexOrFail(repo, keyString, false);
    }

    public void lockTheIndexOrFail(String repo, String keyString, boolean refresh) {
        IndexResponse response = this.client.index(new IndexRequest(repo, "_doc", keyString).opType(DocWriteRequest.OpType.CREATE).source((Map)MapBuilder.immutableMap((Object)"&timestamp", (Object)1)));
        if (response.status() != RestStatus.CREATED) {
            throw new IndexerException("response failed while locking the keyString " + keyString);
        }
        if (refresh) {
            this.client.forceRefresh(repo);
        }
    }

    public boolean checkLock(String repo, String key) {
        return this.client.exists(new GetRequest(repo, "_doc", key));
    }

    public void unlockIndex(String repo, String key) {
        this.client.delete(new DeleteRequest(repo, "_doc", key));
        this.client.forceRefresh(repo);
    }

    public long generateSequence(String repo, String key) {
        return this.client.index(new IndexRequest(repo, "_doc", key).source((Map)MapBuilder.immutableMap())).getVersion();
    }

    public boolean bulkSave(AuthHeader auth, BulkRecord bulkRecord) {
        try {
            BulkRequest bulkRequest = bulkRecord.validator.validateAll(this.client, auth, bulkRecord, new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE));
            if (bulkRequest.numberOfActions() <= 0) {
                return true;
            }
            BulkResponse responses = this.client.bulk(auth, bulkRequest);
            return Indexer.checkResponse(responses, bulkRecord.ignoreErrors, bulkRecord::success, bulkRecord::failure);
        }
        catch (RuntimeException ex) {
            throw Indexer.logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean strictSave(AuthHeader auth, BulkRecord bulkRecord) {
        this.lockTheIndexOrFail(bulkRecord.repo, bulkRecord.model);
        try {
            boolean bl = this.bulkSave(auth, bulkRecord);
            return bl;
        }
        finally {
            this.unlockIndex(bulkRecord.repo, bulkRecord.model);
        }
    }

    public String bulkSave(AuthHeader auth, IndexRecord record) {
        try {
            XContentBuilder result = XContentFactory.jsonBuilder().startObject();
            this.save(auth, record, result);
            this.client.forceRefresh(auth, record.repo);
            return result.endObject().string();
        }
        catch (NoopException nex) {
            return nex.getMessage();
        }
        catch (RuntimeException ex) {
            throw Indexer.logError(ex);
        }
    }

    public void validateRecord(AuthHeader auth, IndexRecord record, BulkRequest bulkRequest, Validator validator) {
        IndexRequest archiveRequest = validator.validate(this.client, auth, record);
        bulkRequest.add(record.request());
        if (archiveRequest != null) {
            bulkRequest.add(archiveRequest);
        }
    }

    public String strictSave(AuthHeader auth, Pair<IndexRecord, IndexRecord> pair) {
        return this.strictSave(auth, (IndexRecord)pair._a, (IndexRecord)pair._b, Validator.STRICT);
    }

    public String strictSave(AuthHeader auth, IndexRecord record, Validator validator) {
        return this.strictSave(auth, record, null, validator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String strictSave(AuthHeader auth, IndexRecord primary, IndexRecord aux, Validator validator) {
        if (this.checkLock(primary.repo, primary.model)) {
            throw new IndexerException("index-model locked for write");
        }
        String lockString = ((IndexRecord)NullUtil.nonNull((Object)aux, (Object)primary)).lockString();
        this.lockTheIndexOrFail(primary.repo, lockString);
        try {
            XContentBuilder result = XContentFactory.jsonBuilder().startObject();
            this.writeStrict(auth, primary, validator, (XContentBuilder)(aux == null ? result : null));
            if (aux != null) {
                this.writeStrict(auth, aux, Validator.OVERRIDE, result);
            }
            String string = result.endObject().string();
            return string;
        }
        catch (NoopException nex) {
            String string = nex.getMessage();
            return string;
        }
        catch (RuntimeException ex) {
            throw Indexer.logError(ex);
        }
        finally {
            this.unlockIndex(primary.repo, lockString);
        }
    }

    private void writeStrict(AuthHeader auth, IndexRecord record, Validator validator, XContentBuilder result) {
        IndexRequest archiveRequest = validator.validate(this.client, auth, record);
        this.save(auth, record, result);
        if (archiveRequest != null) {
            this.client.index(auth, archiveRequest);
        }
    }

    private void save(AuthHeader auth, IndexRecord record, XContentBuilder result) {
        IndexResponse response;
        DocWriteRequest<?> request = record.request();
        Object object = request instanceof IndexRequest ? this.client.index(auth, (IndexRequest)request) : (response = request instanceof DeleteRequest ? this.client.delete(auth, (DeleteRequest)request) : null);
        if (response != null && result != null) {
            result.field("&model", record.model);
            result.field("&id", record.id);
            result.field("&timestamp", record.timestamp);
            result.field("&result", (String)NullUtil.nonNull((Object)record.getResult(), (Object)response.getResult().getLowercase()));
        }
    }

    private static boolean checkResponse(BulkResponse responses, IgnoreErrors ignore, BiConsumer<String, String> successHandler, BiConsumer<String, String> failureHandler) {
        boolean noErrors = true;
        for (BulkItemResponse response : responses) {
            if (response.isFailed()) {
                String failureMessage = response.getFailureMessage();
                if (ignore.ignoreFailure(failureMessage)) continue;
                noErrors = false;
                failureHandler.accept(response.getId(), failureMessage);
                continue;
            }
            successHandler.accept(response.getId(), response.getResponse().getResult().getLowercase());
        }
        return noErrors;
    }

    private static RuntimeException logError(RuntimeException ex) {
        if (ex instanceof IndexerException) {
            log.error("two phase commit failed: " + ex.getMessage());
            return ex;
        }
        log.error("two phase commit failed: " + ex.getMessage(), (Throwable)ex);
        return new IndexerException(ex.getMessage(), ex);
    }

    public Indexer(ElasticClient client) {
        this.client = client;
    }
}

