/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.common;

import io.polyglotted.common.util.MapBuilder;
import java.util.Map;

public enum DocStatus {
    LIVE,
    UPDATED,
    DELETED,
    PENDING,
    PENDING_DELETE,
    REJECTED,
    DISCARDED;

    private static final Map<String, DocStatus> STATUS_MAP;

    public static DocStatus fromStatus(String status) {
        return STATUS_MAP.get(status);
    }

    private static Map<String, DocStatus> buildStatusMap() {
        MapBuilder.ImmutableMapBuilder builder = MapBuilder.immutableMapBuilder();
        for (DocStatus status : DocStatus.values()) {
            builder.put((Object)status.name(), (Object)status);
            builder.put((Object)status.name().toLowerCase(), (Object)status);
        }
        return builder.build();
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        STATUS_MAP = DocStatus.buildStatusMap();
    }
}

