/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.CommaUtil;
import io.polyglotted.common.util.InsecureSslFactory;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.ElasticRestClient;
import io.polyglotted.elastic.client.ElasticSettings;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class HighLevelConnector {
    public static ElasticClient highLevelClient(ElasticSettings settings) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])HighLevelConnector.buildHosts(settings)).setMaxRetryTimeoutMillis(settings.retryTimeoutMillis);
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(settings.connectTimeoutMillis).setSocketTimeout(settings.socketTimeoutMillis));
        if (settings.insecure) {
            restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(InsecureSslFactory.insecureSslContext((String)settings.host, (int)settings.port)).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()));
        }
        return new ElasticRestClient(restClientBuilder, settings.bootstrapAuth());
    }

    private static HttpHost[] buildHosts(ElasticSettings settings) {
        List hosts = CommaUtil.commaSplit((String)settings.host);
        return (HttpHost[])CollUtil.transform((Iterable)hosts, node -> new HttpHost(Objects.requireNonNull(node), settings.port, settings.scheme)).toArray(HttpHost.class);
    }
}

