/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.EsAuth;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.index.IndexRecord;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Finder {
    private static final Logger log = LoggerFactory.getLogger(Finder.class);

    public static Map<String, MapResult> findAll(ElasticClient client, EsAuth auth, List<IndexRecord.Builder> builders) {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        for (IndexRecord.Builder rec : builders) {
            if (StrUtil.nullOrEmpty((String)rec.id)) continue;
            log.debug("multi get " + rec.index + " " + rec.id + " " + rec.parent);
            multiGetRequest.add(new MultiGetRequest.Item(rec.index, "_doc", rec.id).routing(rec.parent).parent(rec.parent));
        }
        if (multiGetRequest.getItems().size() == 0) {
            return MapBuilder.immutableMap();
        }
        MapBuilder.ImmutableMapBuilder result = MapBuilder.immutableMapBuilder();
        MultiGetResponse multiGetItemResponses = client.multiGet(auth, multiGetRequest);
        for (MultiGetItemResponse item : multiGetItemResponses.getResponses()) {
            GetResponse get = Finder.checkMultiGet(item).getResponse();
            if (!get.isExists() || get.isSourceEmpty()) continue;
            MapResult document = MapResult.simpleResult((Map)get.getSourceAsMap());
            result.put((Object)MetaFields.keyString(document), (Object)document);
        }
        return result.build();
    }

    public static MapResult findBy(ElasticClient client, EsAuth auth, IndexRecord rec) {
        return Finder.findBy(client, auth, rec.index, rec.model, rec.id, rec.parent);
    }

    public static MapResult findBy(ElasticClient client, EsAuth auth, String repo, String model, String id) {
        return Finder.findBy(client, auth, repo, model, id, null);
    }

    public static MapResult findBy(ElasticClient client, EsAuth auth, String repo, String model, String id, String parent) {
        GetResponse response = client.get(auth, new GetRequest(repo, "_doc", id).routing(parent));
        return response.isExists() && !response.isSourceEmpty() ? MapResult.simpleResult((Map)response.getSource()) : null;
    }

    private static MultiGetItemResponse checkMultiGet(MultiGetItemResponse item) {
        if (item.isFailed()) {
            throw new IllegalStateException("error multi-get item " + item.getFailure().getMessage());
        }
        return item;
    }
}

