/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.HasMeta;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.elastic.common.DocStatus;
import io.polyglotted.elastic.index.IndexRecord;
import java.util.Map;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RecordAction {
    CREATE(DocStatus.UPDATED, "creating", false),
    UPDATE(DocStatus.UPDATED, "updating", false),
    DELETE(DocStatus.DELETED, "deleting", true),
    APPROVE(DocStatus.LIVE, "deleting", true),
    REJECT(DocStatus.UPDATED, "updating", false),
    DISCARD(DocStatus.DISCARDED, "deleting", true);

    private static final Logger log;
    public final DocStatus status;
    public final String message;
    public final boolean isDelete;

    public boolean notCreateOrUpdate() {
        return this != CREATE && this != UPDATE;
    }

    public DocWriteRequest<?> request(IndexRecord record) {
        if (log.isTraceEnabled()) {
            log.trace(this.message + " record " + record.id + " for " + record.model + " at " + record.index);
        }
        return this.isDelete ? new DeleteRequest(record.index, "_doc", record.id).routing(record.parent) : RecordAction.detectSource(new IndexRequest(record.index, "_doc", record.id), record.pipeline, record.source).routing(record.parent);
    }

    private static IndexRequest detectSource(IndexRequest request, String pipeline, Object source) {
        if (source instanceof Map) {
            request.source((Map)source, pipeline == null ? XContentType.JSON : XContentType.CBOR);
        } else if (source instanceof HasMeta) {
            request.source(BaseSerializer.serializeMeta((HasMeta)((HasMeta)source)), XContentType.JSON);
        } else {
            throw new IllegalArgumentException("unknown source for indexing");
        }
        return request.setPipeline(pipeline);
    }

    private RecordAction(DocStatus status, String message, boolean isDelete) {
        this.status = status;
        this.message = message;
        this.isDelete = isDelete;
    }

    static {
        log = LoggerFactory.getLogger(RecordAction.class);
    }
}

