/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.SortedMapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.common.util.UrnUtil;
import io.polyglotted.common.util.UuidUtil;
import io.polyglotted.elastic.common.DocStatus;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.index.RecordAction;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.DocWriteRequest;

public final class IndexRecord {
    public final String index;
    public final String model;
    public final String id;
    public final String parent;
    public final long timestamp;
    public final RecordAction action;
    public final Long baseVersion;
    public final Object source;
    private final MapResult.ImmutableResult ancillary;
    public final String pipeline;

    public String keyString() {
        return UrnUtil.urnOf((String)this.model, (String)this.id);
    }

    public String simpleKey() {
        return UrnUtil.safeUrnOf((Object[])new Object[]{this.model, this.id, this.timestamp});
    }

    public String key() {
        return UrnUtil.safeUrnOf((Object[])new Object[]{this.model, this.parent, this.id, this.timestamp});
    }

    MapResult update(MapResult current) {
        current.putAll((Map)this.ancillary);
        current.put((Object)"&status", (Object)this.action.status);
        return current;
    }

    public DocWriteRequest<?> request() {
        MetaFields.addMeta(this.source, "&key", this.key());
        return this.action.request(this);
    }

    public static Builder createRecord(String repo, String model, String id, Object source) {
        return IndexRecord.createRecord(repo, model, id, null, source);
    }

    public static Builder createRecord(String repo, String model, String id, String parent, Object source) {
        return new Builder(RecordAction.CREATE, repo, model, id, parent, source);
    }

    public static Builder updateRecord(String repo, String model, String id, Long version, Object source) {
        return IndexRecord.updateRecord(repo, model, id, null, version, source);
    }

    public static Builder updateRecord(String repo, String model, String id, String parent, Long version, Object source) {
        return IndexRecord.expired(RecordAction.UPDATE, repo, model, id, parent, version, source);
    }

    public static Builder deleteRecord(String repo, String model, String id, Long version) {
        return IndexRecord.deleteRecord(repo, model, id, null, version);
    }

    public static Builder deleteRecord(String repo, String model, String id, String parent, Long version) {
        return IndexRecord.expired(RecordAction.DELETE, repo, model, id, parent, version, new LinkedHashMap());
    }

    public static Builder expired(RecordAction action, String repo, String model, String id, String parent, Long tstamp, Object src) {
        return new Builder(action, repo, model, id, parent, src).baseVersion(tstamp);
    }

    private static byte[] getBytes(Object v) {
        return v instanceof MapResult ? BaseSerializer.serializeBytes((Object)CollUtil.filterKeys((Map)((MapResult)v), MetaFields::isNotMeta)) : BaseSerializer.serializeBytes((Object)v);
    }

    private static <T> boolean notEmpty(Collection<T> nullable) {
        return nullable != null && !nullable.isEmpty();
    }

    private IndexRecord(String index, String model, String id, String parent, long timestamp, RecordAction action, Long baseVersion, Object source, MapResult.ImmutableResult ancillary, String pipeline) {
        this.index = index;
        this.model = model;
        this.id = id;
        this.parent = parent;
        this.timestamp = timestamp;
        this.action = action;
        this.baseVersion = baseVersion;
        this.source = source;
        this.ancillary = ancillary;
        this.pipeline = pipeline;
    }

    public static class Builder {
        public final String index;
        public final String model;
        public final String id;
        public final String parent;
        private final RecordAction action;
        final String keyString;
        private final Object source;
        private final SortedMapResult ancillary = SortedMapResult.treeResult();
        private Long timestamp = null;
        private Long baseVersion = null;
        private String pipeline = null;

        private Builder(RecordAction action, String index, String modelName, String idStr, String parent, Object object) {
            this.index = Objects.requireNonNull(index);
            this.model = Objects.requireNonNull(modelName);
            byte[] bytes = IndexRecord.getBytes(object);
            this.id = (String)NullUtil.nonNull((Object)idStr, () -> UuidUtil.generateUuid((byte[])bytes).toString().toLowerCase());
            this.parent = parent;
            this.action = Objects.requireNonNull(action);
            this.keyString = UrnUtil.urnOf((String)this.model, (String)this.id);
            this.source = object;
            MetaFields.addMeta(this.source, "&model", this.model);
            MetaFields.addMeta(this.source, "&id", this.id);
            if (StrUtil.notNullOrEmpty((String)parent)) {
                MetaFields.addMeta(this.source, "&parent", parent);
            }
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.keyString, ((Builder)o).keyString);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.keyString, this.action});
        }

        public Builder timestamp(long timestampVal) {
            this.timestamp = timestampVal;
            MetaFields.addMeta(this.source, "&timestamp", String.valueOf(this.timestamp));
            this.ancillary.put((Object)"&expiry", (Object)String.valueOf(this.timestamp));
            return this;
        }

        public Builder user(String user) {
            MetaFields.addMeta(this.source, "&user", Objects.requireNonNull(user));
            this.ancillary.put((Object)"&updater", (Object)user);
            return this;
        }

        public Builder comment(String comment, boolean meta) {
            if (meta) {
                MetaFields.addMeta(this.source, "&comment", Objects.requireNonNull(comment));
            } else {
                this.ancillary.put((Object)"&comment", (Object)Objects.requireNonNull(comment));
            }
            return this;
        }

        public Builder traitFqn(String traitFqn) {
            MetaFields.addMeta(this.source, "&traitFqn", traitFqn);
            return this;
        }

        public Builder traitId(String traitId) {
            MetaFields.addMeta(this.source, "&traitId", Objects.requireNonNull(traitId));
            return this;
        }

        public Builder schema(String schema) {
            MetaFields.addMeta(this.source, "&schema", schema);
            return this;
        }

        public Builder baseVersion(Long baseVersion) {
            this.baseVersion = baseVersion;
            return this;
        }

        public Builder baseTimestamp(Long baseTs) {
            if (baseTs != null) {
                MetaFields.addMeta(this.source, "&baseTimestamp", baseTs);
            }
            return this;
        }

        public Builder status(DocStatus status) {
            MetaFields.addMeta(this.source, "&status", status.name());
            return this;
        }

        public Builder noStatus() {
            MetaFields.removeMeta(this.source, "&status");
            MetaFields.removeMeta(this.source, "&baseTimestamp");
            return this;
        }

        public Builder approvalRoles(Set<String> roles) {
            if (IndexRecord.notEmpty(roles)) {
                MetaFields.addMeta(this.source, "&approvalRoles", roles);
            }
            return this;
        }

        public Builder ttlExpiry(long ttl) {
            MetaFields.addMeta(this.source, "&ttlExpiry", ttl);
            return this;
        }

        public IndexRecord build() {
            return new IndexRecord(this.index, this.model, this.id, this.parent, Objects.requireNonNull(this.timestamp), this.action, this.baseVersion, this.source, (MapResult.ImmutableResult)this.ancillary.immutable(), this.pipeline);
        }

        public String keyString() {
            return this.keyString;
        }

        public Object source() {
            return this.source;
        }

        public Builder pipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }
    }
}

