/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.client;

import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.CommaUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.client.ElasticRestClient;
import io.polyglotted.elastic.client.ElasticSettings;
import io.polyglotted.elastic.common.EsAuth;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;

public class HighLevelConnector {
    public static ElasticClient highLevelClient(ElasticSettings settings, EsAuth auth) {
        return HighLevelConnector.highLevelClient(settings).waitForStatus(auth, "yellow");
    }

    public static ElasticClient highLevelClient(ElasticSettings settings) {
        return new ElasticRestClient(RestClient.builder((HttpHost[])HighLevelConnector.buildHosts(settings)).setMaxRetryTimeoutMillis(settings.retryTimeoutMillis));
    }

    private static HttpHost[] buildHosts(ElasticSettings settings) {
        List masterNodes = CommaUtil.commaSplit((String)settings.masterNodes);
        return (HttpHost[])CollUtil.transform((Iterable)masterNodes, node -> new HttpHost(Objects.requireNonNull(node), settings.port, settings.scheme)).toArray(HttpHost.class);
    }
}

