/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.admin.Field;
import io.polyglotted.elastic.admin.TypeSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public final class Type {
    public final String type = "_doc";
    public final String parent;
    public final boolean strict;
    public final boolean enabled;
    public final boolean enableSource;
    public final boolean enableSize;
    public final boolean includeMeta;
    public final Set<Field> fields;
    public final MapResult.ImmutableResult meta;
    public final Set<String> srcExcludes;

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.mappingJson().equals(((Type)o).mappingJson());
    }

    public int hashCode() {
        return 29 * this.mappingJson().hashCode();
    }

    public String mappingJson() {
        return TypeSerializer.serializeType(this);
    }

    List<String> sourceExcludes() {
        return (List)ListBuilder.immutableListBuilder().addAll(this.srcExcludes).addAll((Iterable)CollUtil.transformColl((Collection)CollUtil.filterColl(this.fields, Field::excludeFromSrc), Field::field)).build();
    }

    public static Builder typeBuilder() {
        return new Builder().exclude("&autoComplete");
    }

    public String toString() {
        return "Type(" + this.type + ", " + this.parent + ", " + this.strict + ", " + this.enabled + ", " + this.enableSource + ", " + this.enableSize + ", " + this.includeMeta + ", " + this.fields + ", " + this.meta + ", " + this.srcExcludes + ")";
    }

    private Type(String parent, boolean strict, boolean enabled, boolean enableSource, boolean enableSize, boolean includeMeta, Set<Field> fields, MapResult.ImmutableResult meta, Set<String> srcExcludes) {
        this.parent = parent;
        this.strict = strict;
        this.enabled = enabled;
        this.enableSource = enableSource;
        this.enableSize = enableSize;
        this.includeMeta = includeMeta;
        this.fields = fields;
        this.meta = meta;
        this.srcExcludes = srcExcludes;
    }

    public static class Builder {
        private String parent;
        private boolean strict = false;
        private boolean enabled = true;
        private boolean enableSource = true;
        private boolean enableSize = true;
        private boolean includeMeta = true;
        private final Set<Field> fields = new TreeSet<Field>();
        private final MapBuilder.ImmutableMapBuilder<String, Object> metaData = MapResult.immutableResultBuilder();
        private final Set<String> srcExcludes = new TreeSet<String>();

        public Builder strict() {
            return this.strict(true);
        }

        public Builder field(Field.FieldBuilder builder) {
            return this.field(builder.build());
        }

        public Builder field(Field field) {
            return this.fields(Collections.singleton(field));
        }

        public Builder fields(Collection<Field> fields) {
            this.fields.removeAll(fields);
            this.fields.addAll(fields);
            return this;
        }

        public Builder exclude(String excl) {
            this.srcExcludes.add(excl);
            return this;
        }

        public Builder metaData(String name, Object value) {
            this.metaData.put((Object)name, value);
            return this;
        }

        public Builder with(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public Type build() {
            return new Type(this.parent, this.strict, this.enabled, this.enableSource, this.enableSize, this.includeMeta, ListBuilder.immutableSet(this.fields), this.metaData.immutable(), ListBuilder.immutableSet(this.srcExcludes));
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enableSource(boolean enableSource) {
            this.enableSource = enableSource;
            return this;
        }

        public Builder enableSize(boolean enableSize) {
            this.enableSize = enableSize;
            return this;
        }

        public Builder includeMeta(boolean includeMeta) {
            this.includeMeta = includeMeta;
            return this;
        }

        private Builder() {
        }
    }
}

