/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.admin;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.elastic.admin.IndexSetting;
import io.polyglotted.elastic.admin.Type;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.EsAuth;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Admin
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Admin.class);
    private static final SecureRandom random = new SecureRandom();
    private final ElasticClient client;

    public String createIndex(EsAuth auth, IndexSetting setting, Type type, String alias) {
        CreateIndexRequest request = Requests.createIndexRequest((String)((String)NullUtil.nonNull((Object)MapRetriever.optStr((Map)setting.mapResult, (String)"index_name"), Admin::uniqueIndexName))).updateAllTypes(true).settings(setting.createJson(), XContentType.JSON).mapping(type.type, type.mappingJson(), XContentType.JSON);
        if (alias != null) {
            request.alias(new Alias(alias));
        }
        return this.createIndex(auth, request);
    }

    public static String uniqueIndexName() {
        return new BigInteger(130, random).toString(32).toLowerCase();
    }

    public Admin(ElasticClient client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.client.close();
    }

    public boolean indexExists(EsAuth auth, String index) {
        return this.client.indexExists(auth, index);
    }

    public String getSettings(EsAuth auth, String index) {
        return this.client.getSettings(auth, index);
    }

    public MapResult.ImmutableResult getMapping(EsAuth auth, String index) {
        return this.client.getMapping(auth, index);
    }

    public String createIndex(EsAuth auth, CreateIndexRequest request) {
        return this.client.createIndex(auth, request);
    }

    public void dropIndex(EsAuth auth, String index) {
        this.client.dropIndex(auth, index);
    }

    public MapResult clusterHealth(EsAuth auth) {
        return this.client.clusterHealth(auth);
    }

    public void putPipeline(EsAuth auth, String id, String resource) {
        this.client.putPipeline(auth, id, resource);
    }

    public boolean pipelineExists(EsAuth auth, String id) {
        return this.client.pipelineExists(auth, id);
    }

    private static interface AdminClient {
        public void close();

        public boolean indexExists(EsAuth var1, String var2);

        public String getSettings(EsAuth var1, String var2);

        public MapResult.ImmutableResult getMapping(EsAuth var1, String var2);

        public String createIndex(EsAuth var1, CreateIndexRequest var2);

        public void dropIndex(EsAuth var1, String var2);

        public MapResult clusterHealth(EsAuth var1);

        public void putPipeline(EsAuth var1, String var2, String var3);

        public boolean pipelineExists(EsAuth var1, String var2);
    }
}

