/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.EsAuth;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.search.Finder;
import io.polyglotted.elastic.search.QueryMaker;
import io.polyglotted.elastic.search.ResponseBuilder;
import io.polyglotted.elastic.search.ResultBuilder;
import io.polyglotted.elastic.search.ScrollWalker;
import io.polyglotted.elastic.search.SearchUtil;
import io.polyglotted.elastic.search.SimpleResponse;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Searcher {
    private static final Logger log = LoggerFactory.getLogger(Searcher.class);
    private final ElasticClient client;

    public Map<String, MapResult> getAll(EsAuth auth, List<IndexRecord.Builder> builders) {
        return Finder.findAll(this.client, auth, builders);
    }

    public MapResult getSourceBy(EsAuth auth, IndexRecord.Builder rec) {
        return Finder.findBy(this.client, auth, rec.index, rec.id, rec.parent);
    }

    public <T> T getById(EsAuth auth, String index, String id, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return this.getById(auth, index, id, null, resultBuilder, verbose);
    }

    public <T> T getById(EsAuth auth, String index, String id, String parent, ResultBuilder<T> resultBuilder, Verbose verbose) {
        return resultBuilder.buildVerbose(Finder.findBy(this.client, auth, index, id, parent), verbose);
    }

    public <T> SimpleResponse searchBy(EsAuth auth, SearchRequest request, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        return SearchUtil.responseBuilder(this.client.search(auth, request), resultBuilder, verbose).build();
    }

    public <T> SimpleResponse scroll(EsAuth auth, String scrollId, TimeValue scrollTime, ResponseBuilder<T> resultBuilder, Verbose verbose) {
        return SearchUtil.responseBuilder(this.client.searchScroll(auth, QueryMaker.scrollRequest(scrollId, scrollTime)), resultBuilder, verbose).build();
    }

    public <T> String searchNative(EsAuth auth, SearchRequest request, ResponseBuilder<T> resultBuilder, boolean flattenAgg, Verbose verbose) {
        XContentBuilder result = XContentFactory.jsonBuilder().startObject();
        SearchResponse response = this.client.search(auth, request);
        SearchUtil.headerFrom(response, result);
        if (SearchUtil.getReturnedHits(response) > 0) {
            List<T> values = resultBuilder.buildFrom(response, verbose);
            result.rawField("results", (BytesReference)new BytesArray(BaseSerializer.MAPPER.writeValueAsBytes(values)), XContentType.JSON);
        }
        return SearchUtil.buildAggs(response, flattenAgg, result).endObject().string();
    }

    public <T> boolean simpleScroll(EsAuth auth, SearchRequest request, ResponseBuilder<T> resultBuilder, Verbose verbose, ScrollWalker<T> walker) {
        boolean errored = false;
        SearchResponse response = this.client.search(auth, request);
        log.info("performing scroll on " + SearchUtil.getTotalHits(response) + " items");
        while (SearchUtil.getReturnedHits(response) > 0) {
            errored = walker.walk(resultBuilder.buildFrom(response, verbose));
            if (errored) {
                SearchUtil.clearScroll(this.client, auth, response);
                break;
            }
            response = SearchUtil.performScroll(this.client, auth, response);
        }
        return errored;
    }

    public Searcher(ElasticClient client) {
        this.client = client;
    }
}

