/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.search;

import com.google.common.collect.ArrayListMultimap;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.common.Verbose;
import io.polyglotted.elastic.search.ResponseBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;

public interface ResultBuilder<T>
extends ResponseBuilder<T> {
    public static final ResultBuilder<?> NullBuilder = MapBuilder::immutableMap;
    public static final ResultBuilder<MapResult> HeaderBuilder = MetaFields::readHeader;
    public static final ResultBuilder<String> IdBuilder = source -> MapRetriever.reqdStr((Map)source, (String)"&id");
    public static final ResultBuilder<MapResult> EmptyBuilder = MapResult::simpleResult;
    public static final ResultBuilder<MapResult> SourceBuilder = source -> MapResult.simpleResult((Map)CollUtil.filterKeys((Map)source, MetaFields::isNotMeta));

    @Override
    default public List<T> buildFrom(SearchResponse response, Verbose verbose) {
        ListBuilder.ImmutableListBuilder builder = ListBuilder.immutableListBuilder();
        for (SearchHit hit : response.getHits()) {
            builder.add(this.buildFromHit(hit, verbose));
        }
        return builder.build();
    }

    default public T buildFromHit(SearchHit hit, Verbose verbose) {
        T result = this.buildVerbose(Objects.requireNonNull(hit).hasSource() ? MapResult.simpleResult((Map)hit.getSourceAsMap()) : MapResult.simpleResult(), verbose);
        Map highlightFields = hit.getHighlightFields();
        if (result instanceof MapResult && !highlightFields.isEmpty()) {
            ArrayListMultimap highlight = ArrayListMultimap.create();
            for (Map.Entry entry : highlightFields.entrySet()) {
                HighlightField field = (HighlightField)entry.getValue();
                for (Text frag : field.fragments()) {
                    highlight.put((Object)field.name(), (Object)frag.string());
                }
            }
            ((MapResult)MapResult.class.cast(result)).put((Object)"&highlight", (Object)highlight.asMap());
        }
        return result;
    }

    default public T buildVerbose(MapResult source, Verbose verbose) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        return verbose.buildFrom(source, this.buildResult(source));
    }

    public T buildResult(MapResult var1);
}

