/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.EsAuth;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.IndexerException;
import io.polyglotted.elastic.index.NoopException;
import io.polyglotted.elastic.index.RecordAction;
import io.polyglotted.elastic.search.Finder;
import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Validator {
    public static final Validator STRICT = new StrictValidator();
    public static final Validator OVERRIDE = new OverwriteValidator();

    public IndexRequest validate(ElasticClient var1, EsAuth var2, IndexRecord var3);

    public static boolean isIdempotent(IndexRecord record, MapResult existing) {
        if (existing == null || record.action.notCreateOrUpdate() || !(record.source instanceof Map)) {
            return false;
        }
        Map current = CollUtil.filterKeys((Map)((MapResult)record.source), MetaFields::isNotMeta);
        return current.equals(CollUtil.filterKeys((Map)existing, MetaFields::isNotMeta));
    }

    public static class OverwriteValidator
    implements Validator {
        private static final Logger log = LoggerFactory.getLogger(OverwriteValidator.class);

        @Override
        public final IndexRequest validate(ElasticClient client, EsAuth auth, IndexRecord record) {
            this.preValidate(client, record);
            MapResult current = Finder.findBy(client, auth, record);
            if (Validator.isIdempotent(record, current)) {
                throw new NoopException(current);
            }
            this.validateCurrent(record, current);
            this.postValidate(record);
            return current == null ? null : OverwriteValidator.createParentRequest(record, current);
        }

        protected void preValidate(ElasticClient client, IndexRecord record) {
        }

        protected void postValidate(IndexRecord record) {
        }

        protected void validateCurrent(IndexRecord record, MapResult current) {
        }

        public static IndexRequest createParentRequest(IndexRecord record, MapResult current) {
            String uniqueId = MetaFields.uniqueId(current);
            MetaFields.addMeta(record.source, "&ancestor", uniqueId);
            if (log.isTraceEnabled()) {
                log.trace("creating archive record " + uniqueId + " for " + record.simpleKey());
            }
            return new IndexRequest(record.index, "_doc", uniqueId).create(true).source((Map)record.update(current)).parent(record.parent);
        }
    }

    public static class StrictValidator
    extends OverwriteValidator {
        private static final Logger log = LoggerFactory.getLogger(StrictValidator.class);

        @Override
        protected void validateCurrent(IndexRecord record, MapResult current) {
            String keyString = record.keyString();
            if (record.action != RecordAction.CREATE) {
                if (current == null) {
                    throw new IndexerException(keyString + " - record not found for update");
                }
                if (record.baseVersion == null) {
                    throw new IndexerException(keyString + " - baseVersion not found for update");
                }
                if (MetaFields.timestamp(current) != record.baseVersion) {
                    throw new IndexerException(keyString + " - version conflict for update");
                }
            } else if (current != null) {
                throw new IndexerException(keyString + " - record already exists");
            }
        }
    }
}

