/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.elastic.client.ElasticClient;
import io.polyglotted.elastic.common.EsAuth;
import io.polyglotted.elastic.index.BulkRecord;
import io.polyglotted.elastic.index.IgnoreErrors;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.IndexerException;
import io.polyglotted.elastic.index.NoopException;
import io.polyglotted.elastic.index.ServerException;
import io.polyglotted.elastic.index.Validator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Indexer {
    private static final Logger log = LoggerFactory.getLogger(Indexer.class);
    private final ElasticClient client;

    public void lockTheIndexOrFail(EsAuth auth, String index, String keyString) {
        this.lockTheIndexOrFail(auth, index, keyString, false);
    }

    public void lockTheIndexOrFail(EsAuth auth, String index, String keyString, boolean refresh) {
        IndexResponse response = this.client.index(auth, new IndexRequest(index, "_doc", keyString).opType(DocWriteRequest.OpType.CREATE).source((Map)MapBuilder.immutableMap((Object)"i", (Object)1)));
        if (response.status() != RestStatus.CREATED) {
            throw ServerException.serverException("response failed while locking the keyString " + keyString);
        }
        if (refresh) {
            this.client.forceRefresh(auth, index);
        }
    }

    public boolean checkLock(EsAuth auth, String index, String key) {
        return this.client.exists(auth, new GetRequest(index, "_doc", key));
    }

    public void unlockIndex(EsAuth auth, String index, String key) {
        this.client.delete(auth, new DeleteRequest(index, "_doc", key));
        this.client.forceRefresh(auth, index);
    }

    public long generateSequence(EsAuth auth, String index, String key) {
        return this.client.index(auth, new IndexRequest(index, "_doc", key).source((Map)MapBuilder.immutableMap())).getVersion();
    }

    public boolean bulkIndex(EsAuth auth, BulkRecord bulkRecord) {
        BulkRequest bulkRequest = bulkRecord.bulkRequest(auth, this);
        if (bulkRequest.numberOfActions() <= 0) {
            return true;
        }
        try {
            BulkResponse responses = this.client.bulk(auth, bulkRequest);
            return Indexer.checkResponse(responses, bulkRecord.ignoreErrors, bulkRecord::success, bulkRecord::failure);
        }
        catch (RuntimeException ex) {
            throw Indexer.logError(ex);
        }
    }

    public String bulkSave(EsAuth auth, IndexRecord record) {
        try {
            XContentBuilder result = XContentFactory.jsonBuilder().startObject();
            this.save(auth, record, result);
            this.client.forceRefresh(auth, record.index);
            return result.endObject().string();
        }
        catch (NoopException nex) {
            return nex.getMessage();
        }
        catch (RuntimeException ex) {
            throw Indexer.logError(ex);
        }
    }

    public BulkRequest validateRecord(EsAuth auth, IndexRecord record, BulkRequest bulkRequest, Validator validator) {
        IndexRequest archiveRequest = validator.validate(this.client, auth, record);
        bulkRequest.add(record.request());
        if (archiveRequest != null) {
            bulkRequest.add(archiveRequest);
        }
        return bulkRequest;
    }

    public String strictSave(EsAuth auth, Pair<IndexRecord, IndexRecord> pair) {
        return this.strictSave(auth, (IndexRecord)pair._a, (IndexRecord)pair._b, Validator.STRICT);
    }

    public String strictSave(EsAuth auth, IndexRecord record, Validator validator) {
        return this.strictSave(auth, record, null, validator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String strictSave(EsAuth auth, IndexRecord primary, IndexRecord aux, Validator validator) {
        String lockString = ((IndexRecord)NullUtil.nonNull((Object)aux, (Object)primary)).simpleKey();
        this.lockTheIndexOrFail(auth, primary.index, lockString);
        try {
            XContentBuilder result = XContentFactory.jsonBuilder().startObject();
            this.writeStrict(auth, primary, validator, (XContentBuilder)(aux == null ? result : null));
            if (aux != null) {
                this.writeStrict(auth, aux, Validator.OVERRIDE, result);
            }
            String string = result.endObject().string();
            return string;
        }
        catch (NoopException nex) {
            String string = nex.getMessage();
            return string;
        }
        catch (RuntimeException ex) {
            throw Indexer.logError(ex);
        }
        finally {
            this.unlockIndex(auth, primary.index, lockString);
        }
    }

    private void writeStrict(EsAuth auth, IndexRecord record, Validator validator, XContentBuilder result) {
        IndexRequest archiveRequest = validator.validate(this.client, auth, record);
        this.save(auth, record, result);
        if (archiveRequest != null) {
            this.client.index(auth, archiveRequest);
        }
    }

    private void save(EsAuth auth, IndexRecord record, XContentBuilder result) {
        IndexResponse response;
        DocWriteRequest<?> request = record.request();
        Object object = request instanceof IndexRequest ? this.client.index(auth, (IndexRequest)request) : (response = request instanceof DeleteRequest ? this.client.delete(auth, (DeleteRequest)request) : null);
        if (response != null && result != null) {
            result.field("&model", record.model);
            result.field("&id", record.id);
            result.field("&timestamp", record.timestamp);
            result.field("&result", response.getResult().getLowercase());
        }
    }

    private static boolean checkResponse(BulkResponse responses, IgnoreErrors ignore, BiConsumer<String, String> successHandler, BiConsumer<String, String> failureHandler) {
        boolean noErrors = true;
        for (BulkItemResponse response : responses) {
            if (response.isFailed()) {
                String failureMessage = response.getFailureMessage();
                if (ignore.ignoreFailure(failureMessage)) continue;
                noErrors = false;
                failureHandler.accept(response.getId(), failureMessage);
                continue;
            }
            successHandler.accept(response.getId(), response.getResponse().getResult().getLowercase());
        }
        return noErrors;
    }

    private static RuntimeException logError(RuntimeException ex) {
        if (ex instanceof IndexerException) {
            log.error("two phase commit failed: " + ex.getMessage());
            return ex;
        }
        log.error("two phase commit failed: " + ex.getMessage(), (Throwable)ex);
        return new IndexerException(ex.getMessage(), ex);
    }

    public Indexer(ElasticClient client) {
        this.client = client;
    }
}

