/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.elastic.index;

import com.google.common.collect.ImmutableList;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.elastic.common.EsAuth;
import io.polyglotted.elastic.common.MetaFields;
import io.polyglotted.elastic.common.Notification;
import io.polyglotted.elastic.index.IgnoreErrors;
import io.polyglotted.elastic.index.IndexRecord;
import io.polyglotted.elastic.index.Indexer;
import io.polyglotted.elastic.index.NoopException;
import io.polyglotted.elastic.index.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.support.WriteRequest;

public final class BulkRecord {
    public final String model;
    public final long timestamp;
    public final List<IndexRecord> records;
    public final IgnoreErrors ignoreErrors;
    private final Validator validator;
    private final Notification.Builder notification;
    public final Map<String, String> failures = MapBuilder.simpleMap();

    BulkRequest bulkRequest(EsAuth esAuth, Indexer indexer) {
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.records.forEach(record -> {
            try {
                indexer.validateRecord(esAuth, (IndexRecord)record, bulkRequest, this.validator);
            }
            catch (NoopException noop) {
                this.success(record.id, "noop");
            }
        });
        return bulkRequest;
    }

    void success(String id, String result) {
        if (this.notification != null) {
            this.notification.keyAction(id, result);
        }
    }

    void failure(String id, String result) {
        this.failures.put(id, result);
    }

    public static Builder bulkBuilder(String repo, String model, long timestamp, String user) {
        return new Builder(repo, model, timestamp, Objects.requireNonNull(user));
    }

    private static boolean isChangeAction(String action) {
        return "created".equals(action) || "updated".equals(action) || "deleted".equals(action);
    }

    private BulkRecord(String model, long timestamp, List<IndexRecord> records, IgnoreErrors ignoreErrors, Validator validator, Notification.Builder notification) {
        this.model = model;
        this.timestamp = timestamp;
        this.records = records;
        this.ignoreErrors = ignoreErrors;
        this.validator = validator;
        this.notification = notification;
    }

    public static class Builder {
        private final String repo;
        private final String model;
        private final long timestamp;
        private final String user;
        @NonNull
        private IgnoreErrors ignoreErrors = IgnoreErrors.STRICT;
        @NonNull
        private Validator validator = Validator.STRICT;
        private Notification.Builder notification;
        private final ListBuilder.ImmutableListBuilder<IndexRecord> records = ListBuilder.immutableListBuilder();

        public Builder withNotification() {
            return this.notification(Notification.notificationBuilder());
        }

        public Builder record(IndexRecord record) {
            this.records.add((Object)record);
            return this;
        }

        public Builder records(Iterable<IndexRecord> records) {
            this.records.addAll(records);
            return this;
        }

        public Builder objects(Iterable<MapResult> objects) {
            return this.records((Iterable<IndexRecord>)CollUtil.transform(objects, this::indexRec));
        }

        private IndexRecord indexRec(MapResult object) {
            return IndexRecord.createRecord(Objects.requireNonNull(this.repo), Objects.requireNonNull(this.model), MetaFields.id(object), object).timestamp(this.timestamp).user(this.user).build();
        }

        public BulkRecord build() {
            ImmutableList recordsList = this.records.build();
            if (this.notification != null) {
                recordsList.forEach(record -> this.notification.key(record.id, record.key()));
            }
            return new BulkRecord(this.model, this.timestamp, (List)recordsList, this.ignoreErrors, this.validator, this.notification);
        }

        public Builder(String repo, String model, long timestamp, String user) {
            this.repo = repo;
            this.model = model;
            this.timestamp = timestamp;
            this.user = user;
        }

        public Builder ignoreErrors(@NonNull IgnoreErrors ignoreErrors) {
            if (ignoreErrors == null) {
                throw new NullPointerException("ignoreErrors");
            }
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public Builder validator(@NonNull Validator validator) {
            if (validator == null) {
                throw new NullPointerException("validator");
            }
            this.validator = validator;
            return this;
        }

        public Builder notification(Notification.Builder notification) {
            this.notification = notification;
            return this;
        }
    }
}

